%% Parameter

% Skript zum Experimentieren

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -

g = 9.81;   % Erdbeschleunigung
m1 = 1;     % 1. Masse
m2 = m1;    % 2. Masse
l1 = 1;     % 1. Pendellaenge
l2 = l1;    % 2. Pendellaenge
phi10 =90;  % Startwinkel
%% Anfangswerte
y0 = pi*[phi10;0;0;0]/180; % phi, dphi1, phi2, dphi2
%% Energie
f1 = y0(1);
f2 = y0(3);
p1 = (m1+m2)*l1^2.*y0(2)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(4);
p2 = m2*l2^2*y0(4)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(2);
E0 = 1./(m1 + m2*sin(f1-f2)^2)*(p1^2/(2*l1^2) + (m1+m2)/m2 * p2^2/(2*l2^2)-p1*p2/(l1*l2)*cos(f1-f2)) ...
     -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2)
%% Poincare Startwerte
pscale = 180/pi;
y0 = pi*[rand*phi10/2;randn*pscale/2;0;randn*pscale/2]/180; % phi, dphi1, phi2, dphi2
f1 = y0(1);
f2 = y0(3);
p1 = (m1+m2)*l1^2.*y0(2)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(4);
p2 = m2*l2^2*y0(4)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(2);
E1 = 1./(m1 + m2*sin(f1-f2)^2)*(p1^2/(2*l1^2) + (m1+m2)/m2 * p2^2/(2*l2^2)-p1*p2/(l1*l2)*cos(f1-f2)) ...
     -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2)
 
 %%
 E1,E0
 if E1<E0
 fun = @(phi2) dopPendelanffun(phi2,y0,E0,m1,m2,l1,l2,g); 
 phi2 = fzero(fun,pi*randn/180)
 end
 