function dy = dopPendelLagDGL(t,y,m1,m2,l1,l2)
% Differentialgleichung

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 3.1
% 05.2016

% Konstante
g = 9.81;

% Differentialgleichungen
dy(1)=y(2);
%
dy(2)=-((g*(2*m1+m2)*sin(y(1))+m2*(g*sin(y(1)-2*y(3))+2*(l2*y(4)^2+...
    l1*y(2)^2*cos(y(1)-y(3)))*sin(y(1)-y(3))))/...
    (2*l1*(m1+m2-m2*cos(y(1)-y(3))^2)));
%
dy(3)=y(4);
%
dy(4)=(((m1+m2)*(l1*y(2)^2+g*cos(y(1)))+l2*m2*y(4)^2*cos(y(1)-y(3)))*...
    sin(y(1)-y(3)))/(l2*(m1+m2-m2*cos(y(1)-y(3))^2));
%
%
dy = dy.';
