function dy = dopPendelDGL(t,y,m1,m2,l1,l2,E)
% Differentialgleichung zu DopPendel.m

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 1.5
% 09.2015


% Konstante
g = 9.81;
% Vorfaktoren
sd = sin(y(1)-y(2));
cd = cos(y(1)-y(2));
sv1 = 1./(m1+m2*sd^2);
l1q = l1*l1;
l12 = l1*l2;
l2q = l2*l2;
% Differentialgleichungen
%
dy(1) = sv1*(y(3)/l1q-y(4)/l12*cd);
%
dy(2) = sv1*((m1+m2)/m2*y(4)/l2q - y(3)/l12*cd);
%
pv1 = sv1*y(3)*y(4)/(l12) * sd;
%pv2 = sv1*sin(2*(y(1)-y(2))) * (m2*y(3)^2/(2*l1q) + (m1+m2)*y(4)^2/(2*l2q) - m2*y(3)*y(4)/(l12)*cd);
pv2 = m2*sin(2*(y(1)-y(2)))*(E + (m1+m2)*g*l1*cos(y(1)) + m2*g*l2*cos(y(2)));
%
dy(3) = -pv1 + pv2 - (m1+m2)*g*l1*sin(y(1));
%
dy(4) = pv1 -pv2 -m2*g*l2*sin(y(2));
%
dy = dy.';
