%%
clear,clc

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 2.5
% 09.2015

%% Parameter
g = 9.81;   % Erdbeschleunigung
m1 = 1;     % 1. Masse
m2 = m1;    % 2. Masse
l1 = 1;     % 1. Pendellaenge
l2 = l1;    % 2. Pendellaenge
%% Anfangswerte
y0 = pi*[6;0;0;0]/180;  % in Grad
%% Energie
f1 = y0(1);
f2 = y0(2);
p1 = y0(3);
p2 = y0(4);
%
E = 1./(m1 + m2*sin(f1-f2)^2)*(p1^2/(2*l1^2) + (m1+m2)/m2 * p2^2/(2*l2^2)-p1*p2/(l1*l2)*cos(f1-f2)) ...
    -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2)
%%
tmax = 25;
options = odeset('RelTol',1e-8,'AbsTol',1e-10,'BDF','on','MaxOrder',5);
tic
[t,y] = ode15s(@(t,y) dopPendelDGL(t,y,m1,m2,l1,l2,E),[0,tmax],y0,options);
toc
%%
f1 = y(100,1);
f2 = y(100,2);
p1 = y(100,3);
p2 = y(100,4);
%
E100 = 1./(m1 + m2*sin(f1-f2)^2)*(p1^2/(2*l1^2) + (m1+m2)/m2 * p2^2/(2*l2^2)-p1*p2/(l1*l2)*cos(f1-f2)) ...
    -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2)
%%
f1 = y(:,1);
f2 = y(:,2);
p1 = y(:,3);
p2 = y(:,4);
%
Eend = 1./(m1 + m2*sin(f1-f2).^2).*(p1.^2/(2*l1^2) + (m1+m2)/m2 * p2.^2/(2*l2^2)-p1.*p2/(l1*l2).*cos(f1-f2)) ...
    -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2);
figure, plot(t,Eend),shg
hold on
plot([t(1),t(end)],[E*0.95 E*0.95],[t(1),t(end)],[E*1.05 E*1.05])
%plot(t1,Eend1,'m')

