function varargout = DopPendelPoincare(varargin)
% DOPPENDELPOINCARE MATLAB code for DopPendelPoincare.fig
%      DOPPENDELPOINCARE, by itself, creates a new DOPPENDELPOINCARE or raises the existing
%      singleton*.
%
%      H = DOPPENDELPOINCARE returns the handle to a new DOPPENDELPOINCARE or the handle to
%      the existing singleton*.
%
%      DOPPENDELPOINCARE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DOPPENDELPOINCARE.M with the given input arguments.
%
%      DOPPENDELPOINCARE('Property','Value',...) creates a new DOPPENDELPOINCARE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before DopPendelPoincare_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to DopPendelPoincare_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help DopPendelPoincare

% Last Modified by GUIDE v2.5 31-May-2016 21:31:06

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 3.1
% 05.2016

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @DopPendelPoincare_OpeningFcn, ...
                   'gui_OutputFcn',  @DopPendelPoincare_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before DopPendelPoincare is made visible.
function DopPendelPoincare_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to DopPendelPoincare (see VARARGIN)

% Choose default command line output for DopPendelPoincare
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
set(handles.aus,'Visible','off','Enable','off')

% UIWAIT makes DopPendelPoincare wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = DopPendelPoincare_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function phi1_Callback(hObject, eventdata, handles)
% hObject    handle to phi1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of phi1 as text
%        str2double(get(hObject,'String')) returns contents of phi1 as a double



% --- Executes during object creation, after setting all properties.
function phi1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to phi1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pb1.
function pb1_Callback(hObject, eventdata, handles)
% hObject    handle to pb1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

phi1 = str2num(get(handles.phi1,'String'))
%get(handles.pb1)
be = get(handles.pb1,'String');
if be(1) == 'b'
        disp('bitte auf aus klicken')
elseif be(1) == 'N'
        handles.figure1;hold off
        set(handles.aus,'Visible','off','Enable','off','Value',0)
        set(handles.txt1,'Visible','on')
        set(handles.phi1,'Visible','on','String','phi1','Enable','on')
        set(handles.txt2,'String','Zum Starten bitte klicken')
        set(handles.pb1,'String','Start')

        
else
        set(handles.txt2,'String','Zufallsberechnung')
        set(handles.txt1,'Visible','off')
        set(handles.phi1,'Visible','off','Enable','off')

        pause(0.1)

        DopPendPoinVisu(handles,phi1)
end

%% Parameter
function DopPendPoinVisu(handles,phi10)
g = 9.81;   % Erdbeschleunigung
m1 = 1;     % 1. Masse
m2 = m1;    % 2. Masse
l1 = 1;     % 1. Pendellaenge
l2 = l1;    % 2. Pendellaenge
title(['\phi_1 = ',num2str(phi10)])
disp('Bitte etwas Geduld')
%% Anfangswerte
y0 = pi*[phi10;0;0;0]/180; % phi, dphi1, phi2, dphi2
%y0=get(18,'UserData')
%% Energie
f1 = y0(1);
f2 = y0(3);
p1 = (m1+m2)*l1^2.*y0(2)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(4);
p2 = m2*l2^2*y0(4)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(2);
E0 = 1./(m1 + m2*sin(f1-f2)^2)*(p1^2/(2*l1^2) + (m1+m2)/m2 * p2^2/(2*l2^2)-p1*p2/(l1*l2)*cos(f1-f2)) ...
     -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2);
%%  ode45 aufrufen
tmax = 300;
options = odeset('RelTol',1e-8,'AbsTol',1e-10,'Events', @(t,y) dopPendelEvent(t,y,m1,m2,l1,l2));
%tic
[t,y,te,ye,ie] = ode45(@(t,y) dopPendelLagDGL(t,y,m1,m2,l1,l2),[0,tmax],y0,options);
%toc
%% Poincareschnitt
f1e = ye(:,1);
f2e = ye(:,3);
dfe1 = y(:,2);
p1e = (m1+m2)*l1^2.*ye(:,2)+m2*l1*l2*cos(ye(:,1)-ye(:,3)).*ye(:,4);
p2e = m2*l2^2*ye(:,4)+m2*l1*l2*cos(ye(:,1)-ye(:,3)).*ye(:,2);
f1e = f1e(p2e>=0);
p1e = p1e(p2e>=0);
dfe1 = dfe1(p2e>=0);
plot(f1e,p1e,'.k','MarkerSize',3), hold on
title(['\phi_1 = ',num2str(phi10)])
set(gcf,'UserData',y0)
%%
for k=1:10
    clear t te y ye
    disp('ich rechne noch'),10-k
    pscale = 180/pi;
y0 = pi*[rand*phi10/3;randn*pscale/2;0;randn*pscale/2]/180; % phi, dphi1, phi2, dphi2
f1 = y0(1);
f2 = y0(3);
p1 = (m1+m2)*l1^2.*y0(2)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(4);
p2 = m2*l2^2*y0(4)+m2*l1*l2*cos(y0(1)-y0(3)).*y0(2);
E1 = 1./(m1 + m2*sin(f1-f2)^2)*(p1^2/(2*l1^2) + (m1+m2)/m2 * p2^2/(2*l2^2)-p1*p2/(l1*l2)*cos(f1-f2)) ...
     -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2);
 
 %%
 if E1<E0
 fun = @(phi2) dopPendelanffun(phi2,y0,E0,m1,m2,l1,l2,g); 
 phi2 = fzero(fun,pi*randn/180);

y00 = y0;
y00(3) = phi2;
%tic
[t,y,te,ye,ie] = ode45(@(t,y) dopPendelLagDGL(t,y,m1,m2,l1,l2),[0,tmax],y00,options);
%toc
%%
f1 = y(:,1);
f2 = y(:,3);
p1 = (m1+m2)*l1^2.*y(:,2)+m2*l1*l2*cos(y(:,1)-y(:,3)).*y(:,4);
p2 = m2*l2^2*y(:,4)+m2*l1*l2*cos(y(:,1)-y(:,3)).*y(:,2);
%
%Eend = 1./(m1 + m2*sin(f1-f2).^2).*(p1.^2/(2*l1^2) + (m1+m2)/m2 * p2.^2/(2*l2^2)-p1.*p2/(l1*l2).*cos(f1-f2)) ...
%    -(m1+m2)*g*l1*cos(f1) - m2*g*l2*cos(f2);
%% Poincareschnitt
try
f1e = ye(:,1);
f2e = ye(:,3);
dfe1 = ye(:,2);
p1e = (m1+m2)*l1^2.*ye(:,2)+m2*l1*l2*cos(ye(:,1)-ye(:,3)).*ye(:,4);
p2e = m2*l2^2*ye(:,4)+m2*l1*l2*cos(ye(:,1)-ye(:,3)).*ye(:,2);
f1e = f1e(p2e>=0);
p1e = p1e(p2e>=0);
dfe1 = dfe1(p2e>=0);
plot(f1e,p1e,'.k','MarkerSize',4), hold on
catch
    k
    lasterr
end
 end
end
beend=0;
set(handles.aus,'Visible','on','Enable','on')
%set(handles.pb1,'Value','0')
set(handles.txt2,'String','Startpunkte mit Maus anklicken')
set(handles.pb1,'String','beenden:aus')
while ~beend
    clear t te y ye
    pscale = 180/pi;
[y0(1),p1] = ginput(1);
f1 = y0(1);
y0(3) = 0;
f2 = y0(3);
a = (m1 + m2)/(m2 * 2*l2^2);
b = - p1/(l1*l2)*cos(f1);
c = -(E0 +(m1 + m2)*g*l1*cos(f1) + m2*g*l2)*(m1 + m2*sin(f1)^2) + p1^2/(2*l1^2);
p2 = (-b +sqrt(b^2 - 4*a*c))/(2*a);
E1 = 1./(m1 + m2*sin(f1)^2)*(p1^2/(2*l1^2) + (m1+m2)/m2 * p2^2/(2*l2^2)-p1*p2/(l1*l2)*cos(f1)) ...
     -(m1+m2)*g*l1*cos(f1) - m2*g*l2; 
%%
Ac(1,1) = (m1 + m2)*l1^2;
Ac(1,2) = m2 * l1*l2*cos(f1);
Ac(2,2) = m2 * l2^2;
Ac(2,1) = m2 * l1*l2*cos(f1);
p12 = [p1;p2];
dPhi = Ac\p12;
y0(2) = dPhi(1);
y0(4) = dPhi(2);
if ~isreal(y0)
    disp('ausserhalb der Energieschaale')
    disp('komplexe Anfangswerte')
else
plot(f1,p1,'.k','MarkerSize',4), hold on
 %%
%tic
[t,y,te,ye,ie] = ode45(@(t,y) dopPendelLagDGL(t,y,m1,m2,l1,l2),[0,tmax],y0,options);
%toc
%%
f1 = y(:,1);
f2 = y(:,3);
p1 = (m1+m2)*l1^2.*y(:,2)+m2*l1*l2*cos(y(:,1)-y(:,3)).*y(:,4);
p2 = m2*l2^2*y(:,4)+m2*l1*l2*cos(y(:,1)-y(:,3)).*y(:,2);

%% Poincareschnitt
try
f1e = ye(:,1);
f2e = ye(:,3);
p1e = (m1+m2)*l1^2.*ye(:,2)+m2*l1*l2*cos(ye(:,1)-ye(:,3)).*ye(:,4);
p2e = m2*l2^2*ye(:,4)+m2*l1*l2*cos(ye(:,1)-ye(:,3)).*ye(:,2);
f1e = f1e(p2e>=0);
p1e = p1e(p2e>=0);
plot(f1e,p1e,'.k','MarkerSize',4), hold on
catch
    lasterr
end

%set(gcf,'UserData',y00)
end
 beend=get(handles.aus,'Value');
end


% --- Executes on button press in aus.
function aus_Callback(hObject, eventdata, handles)
% hObject    handle to aus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of aus

set(handles.txt2,'String','Neustart dann klicken')
set(handles.pb1,'String','Neustart')

% --------------------------------------------------------------------
function speichern_Callback(hObject, eventdata, handles)
% hObject    handle to speichern (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.txt2,'Visible','off')
set(handles.pb1,'Visible','off')
set(handles.aus,'Visible','off')
saveas(handles.figure1,['DopPendelPhi1_',get(handles.phi1,'String'),'.fig']) 
saveas(handles.figure1,['DopPendelPhi1_',get(handles.phi1,'String'),'.pdf']) 

pause(0.3)

set(handles.txt2,'Visible','on')
set(handles.pb1,'Visible','on')
set(handles.aus,'Visible','on')