function [t,y,ts]=testaufexEuler
% Freier Fall mit Stokes Reibung
% --> Oesterreicher Felix Baumgartner --> Fallschirmspringer
% Endgeschwindigkeit 350 m/s (Annahme) Gewicht 80 kg
% Rueckgabewerte t = Zeit, y = Geschwindigkeit, ts Schrittweite 

% wegen Verwendung eines private Folders in Dummy-Function wandeln 

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 1.1
% 02.2016

m = 80;             % Gewicht
g = 9.81;           % Erdbeschleunigung
vinf = 350;         % Grenzgeschwindigkeit m/s
k = m*g/vinf^2;     % Luftreibungskoeffizient kg * m/s^2 / (m/s)^2 = kg/m  
%
tic
ti = [0, 150];
y0=0.;
ts = 0.005;
of = @ testode;

[t,y,ts] = exEuler(of, ti, ts, y0);
toc
format long
t(end),y(end),vinf

ye = -vinf.*tanh(g.*t/vinf);
plot(t,y,t,ye),shg
(y(end)-ye(end))/y(end)