function testaufRK4

% Freier fall mit Stokes Reibung
% --> Oesterreicher Felix Baumgartner --> Fallschirmspringer
% Endgeschwindigkeit 350 m/s (Annahme) Gewicht 80 kg

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 1.1
% 05.2016

m = 80;             % Gewicht
g = 9.81;           % Erdbeschleunigung
vinf = 350;         % Grenzgeschwindigkeit m/s
k = m*g/vinf^2;     % Luftreibungskoeffizient kg * m/s^2 / (m/s)^2 = kg/m  
%
tic
ti = [0, 150];
y0=0.;
ts = 0.005;
of = @ testode;

[t,y,ts] = RK4(of, ti, ts, y0);
toc
format long
t(end),y(end),vinf
%
% v = 9.81/2*(1-exp(-2*t(end)))
% (y(end)-v)/v*100
% te = t(end);
% ye = 1/3*t.^3 + 1/72 * t.^8;
% (y(end)-ye(end))/y(end)*100
% ye = 1 - exp(-sin(t)) - sin(t);
ye = -vinf.*tanh(g.*t/vinf);
plot(t,y,t,ye),shg
(y(end)-ye(end))/y(end)