function [t,y,tsn] = exEuler(of, ti, ts, y0)

% expliziter Euler (Vorwaerts Euler)
% of Function Handle der Differentialgleichung
% ti Berechnungsintervall
% ts Schrittweite
% y0 Anfangsbedingung
% t,y Rueckgabewerte Funktion
% tsn = korrigierte Schrittweite

% Hinweis: Parameter an die Funktion of koennte mittels varargin uebergeben werden  

% W. Schweizer
% Simulation physikalischer Systeme
% 05/2016
% vers. 1.1

% Anpassen der korrekte Schrittweite
dt = ti(2)-ti(1);
n = round(dt/ts);   % Anzahl der Berechnungsschritte
tsn = dt/n;
t = linspace(ti(1),ti(2),n);

y(1) = y0;   % Startwert

for l=1:n-1
    y(l+1) = y(l) + tsn * of(t(l),y(l));
end