function [t,y,tsn] = RK4(of, ti, ts, y0)

% Runge-Kutta 4.Ordnung
% dient der Untersuchung Einfluss der Schrittweite
% of Function Handle der Differentialgleichung
% ti Berechnungsintervall
% ts Schrittweite
% y0 Anfangsbedingung
% t,y Rueckgabewerte Funktion
% tsn = korrigierte Schrittweite

% Hinweis: Parameter an die Funktion of koennte mittels varargin uebergeben werden  

% W. Schweizer
% Simulation physikalischer Systeme
% 05/2016
% vers. 1.0

% Anpassen der korrekte Schrittweite
dt = ti(2)-ti(1);
n = round(dt/ts);   % Anzahl der Berechnungsschritte
tsn = dt/n;
t = linspace(ti(1),ti(2),n);

y(1) = y0;   % Startwert

for l=1:n-1
    k1 = of(t(l),y(l));
    k2 = of(t(l)+tsn/2 , y(l) + tsn/2*k1);
    k3 = of(t(l)+tsn/2 , y(l) + tsn/2*k2);
    k4 = of(t(l)+tsn   , y(l) + tsn*k3);
    
    y(l+1) = y(l) + tsn*(k1 + 2*k2 +2*k3 + k4)/6;
end

    
    