function [poinwert,isterminal,richt] = poinevent(t,y,epsilon)
% Eventfunktion zu nicht-verschwindendem Drehimpuls
% Ereignis ist das Durchstossen der Poincareflaeche
% Die Poincareflaeche ist definiert durch mu-nu = 0;

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 1.0 2016

tphi1 = y(1)/y(2);
sphi1 = tphi1/sqrt(1+tphi1^2);
tphi2 = y(3)/y(4);
sphi2 = tphi2/sqrt(1+tphi2^2);
mu = y(1)/sphi1;
nu = y(3)/sphi2;

%persistent np
%if isempty(np)
%    np=0
%end
%np=np+1
poinwert=mu-nu;
if abs(mu-nu)< 5.e-14
    poinwert=0;
    isterminal=0;
    richt=0;
end
isterminal=0;
richt=0;
% if (abs(poinwert)<5.e-14)
%     ok=1
%     poinwert=0;
%     isterminal=0;
%     richt=0;
% end
%     xa=sqrt(-2*epsilon)*(mu+nu)/2;
%     pmu =  y(5)*sphi1 + y(6)*sqrt(1-sphi1^2);
%     pnu =  y(7)*sphi2 + y(8)*sqrt(1-sphi2^2);
%     pxa = (pmu + pnu)/2;
%     %ok=1
%     %zwei=0.5*(y(3)*y(3)+y(4)*y(4)) -epsilon*(y(1)*y(1)+y(2)*y(2))+...
%     %1/8*(y(1)*y(1)*y(2)*y(2))*(y(1)*y(1)+y(2)*y(2))
%      plot(xa,pxa,'.',...
%      'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
%      plot(-xa,pxa,'.',...
%      'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
%      plot(xa,-pxa,'.',...
%      'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
%      plot(-xa,-pxa,'.',...
%      'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
     %xaa = [xaa,xa];
     %pxaa = [pxaa,pxa];
     %save poin xaa pxaa
%end

