% Poincareschnitt Bahn parallel zum Magnetfeld 

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 1.0 2016

%fh = figure;
fs = subplot(2,2,2);
plot(0,0,'.k'),hold on
%%
% ausgewaehlte Startwerte
%h1=subplot(2,1,1)
y0(2)=0;
epsilon=-0.3;
% Ausgesuchte Startwerte
farb=[0,0,0];%rand(1,3);
y0(3)=0;
y0(1)=0.00375;
% Aus der Energieerhaltung folgt
y0(4)=sqrt(4+2*epsilon*y0(1)^2);
%options = odeset('RelTol',1e-13,'AbsTol',1e-13,'MaxStep',0.1);
zwei=0.5*(y0(3)*y0(3)+y0(4)*y0(4)) -epsilon*(y0(1)*y0(1)+y0(2)*y0(2))+...
    1/8*(y0(1)*y0(1)*y0(2)*y0(2))*(y0(1)*y0(1)+y0(2)*y0(2))
% options = odeset('RelTol',1e-10,'AbsTol',1e-10,'MaxStep',0.1,'Events',@poinevent);
options = odeset('RelTol',1e-10,'AbsTol',1e-10,'MaxStep',0.1,'Events',@(t,y) poinevent(t,y,epsilon));
tmax=100;
xa=sqrt(-2*epsilon)*y0(1);
plot(xa,y0(3),'.',...
    'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
hold on
plot(-xa,y0(3),'.',...
    'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
plot(xa,-y0(3),'.',...
    'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
plot(-xa,-y0(3),'.',...
    'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
%[t,y] = ode45(@diahdgl,[0 tmax],y0,options,epsilon,farb);
[t,y,te,ye,ie] = ode45(@(t,y) diahdgl(t,y,epsilon),[0 tmax],y0,options);
% Visualisierung
xa=sqrt(-2*epsilon)*ye(:,1);
ya = ye(:,3);
xa = [xa;-xa;xa;-xa];
ya = [ya;ya;-ya;-ya];
    plot(xa,ya,'.',...
    'MarkerSize',1,'MarkerFaceColor',farb,'MarkerEdgeColor',farb)
%xlim([-2,2]),ylim([-2,2])
%axis equal
%hold off
%%
title('\epsilon = -0.3')
xlabel('\mu')
ylabel('p_\mu')
