
function dy = diahdgl(t,y,epsilon)
% Differentialgleichung des diamagnetischen Wasserstoffatoms
% y(1)=mu, y(2)=nu, y(3)=p_mu, y(4)=p_nu

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB -
% Vers. 4.0 2016

%persistent n
%if isempty(n)
%    n=0
%end
%n=n+1
dy(1)=y(3);
dy(2)=y(4);
dy(3)=2*epsilon*y(1) - 1/4*y(1)*y(2)^4 - 1/2*y(1)^3*y(2)^2;
dy(4)=2*epsilon*y(2) - 1/4*y(2)*y(1)^4 - 1/2*y(2)^3*y(1)^2;
dy=dy';
dy(1)=sign(dy(1))*sqrt(abs(4-y(4)*y(4) +2*epsilon*(y(1)*y(1)+y(2)*y(2))-...
    1/4*(y(1)*y(1)*y(2)*y(2))*(y(1)*y(1)+y(2)*y(2))));
%zwei=0.5*(y(3)*y(3)+y(4)*y(4)) -epsilon*(y(1)*y(1)+y(2)*y(2))+...
%    1/8*(y(1)*y(1)*y(2)*y(2))*(y(1)*y(1)+y(2)*y(2))