%% Ballistisches Pendel
% m1, v0 Masse und Geschwindigkeit vor dem Stoss der Kugel
% m2 Pendelmasse - vor dem Stoss in Ruhe
% v Geschwindigkeit nach dem Stoss

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% Version 1.1  2016

%
% Aus der Impulserhaltung folgt
%%
% $m_1 v_0 = (m_1 + m_2) v$ 
%% Pendelbewegung
% h maximale Hoehe des Pendels
%
% aus der Energieerhaltung folgt
%%
% $\frac{1}{2} \; (m_1 + m_2) v^2 = (m_1 + m_2) g h$

% und daraus
%%
% $v_0 = \frac{m_1 + m_2}{m} \sqrt{2 g h}$
m1 = 0.01; % kg
m2 = 5;    % kg
g  = 9.81; % m/s^2
% Berechnung und Visualisierung
h  = linspace(0.01,0.1);
v  = (m1+m2)/m1 * sqrt(2*g*h);
plot (h,v)
xlabel('h [m]'), ylabel('v [m/s]'),shg