function [xs2,mt2,bt2,phi0] = GerGESchnitt(epsilon,R0,phi0,mt,xs,ys)
% Schnitt mit der deformierten Ellipse
% wird von chaos_stossGE.m aufgerufen

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% Version 2.9  2016
%
% Berechnung der Tangente
dx = -epsilon*sin(phi0)*cos(phi0) - (1+epsilon*cos(phi0))*sin(phi0);
dy = -epsilon*sin(phi0)*sin(phi0) + (1+epsilon*cos(phi0))*cos(phi0);
mtan = dy/dx;
phit = atan(mtan);
% Berechnung der Geradengleichung der Sekante
tanp = (mtan - mt)/(1+mtan*mt);
mt2 = (mtan+tanp)/(1-tanp*mtan);
%
bt2 = ys - mt2*xs;
hphi2 = @(phi)  R0*(1+epsilon*cos(phi)).*sin(phi) - mt2 * R0 * (1+epsilon*cos(phi)).*cos(phi)-bt2;
phi0 = fzero(hphi2,atan(mt2));
xs2 = R0*(1+epsilon*cos(phi0)).*cos(phi0);
phis = -pi-0.2;
while abs(xs-xs2)<1e-05
    phis = phis+0.2;
    phi0 = fzero(hphi2,phis);
    xs2 = R0*(1+epsilon*cos(phi0)).*cos(phi0);
    %xs,xs2,phi0
    if(phis>pi+0.3)
        return
    end
end