function [xs,ys] = GerEllSchnitt(a,b,mt,bt,vt,xsv,ysv)
% Berechnung des Schnittpunkts der reflektierten Geraden mit der Ellipse

% W. Schweizer
% Simulation physikalischer Systeme - Computational Physics mit MATLAB 
% Version 2.3  2016

cg = bt^2 - b^2;
ag = (b/a)^2 + mt^2;
bg = 2*mt*bt;
wurzel = sqrt(bg^2 - 4*ag*cg);
xs1 = (-bg + wurzel)/(2*ag);
xs2 = (-bg - wurzel)/(2*ag);
ys1 = mt*xs1 + bt;
ys2 = mt*xs2 + bt;
%plot(xs1,ys1,'mo',xs2,ys2,'go')
if vt > 0
    xs = xs1;
    ys = ys1;
elseif vt < 0
    xs = xs2;
    ys = ys2;
else
    %'hier'
    xtest = abs(xs1-xsv);
    ytest = abs(ys1-ysv);
    xs = xs1;
    ys = ys1;
    if (xtest < 1e-10) & (ytest < 1e-10)
        xs = xs2;
        ys = ys2;
    end
end