


// k7p9.c ATmega16 DCF77-Uhr
// Port A: Sekundenanzeige dezimal
// Port B: Stundenanzeige dezimal
// Port C: Minutenanzeige dezimal
// Port D: D6: ICP1=DCF77 Eingang D7 und D5-D0 frei fr Sonderfunktionen
// Konfiguration Quarz 3.6864 MHz  JTAG Interface disabled! 
#define     TAKT 3686400ul     // Systemtakt 3.6864 MHz
#define     ICP1 PIND6         // Eingang DCF77-Signal
#include    <avr/io.h>         // Deklarationen
#include    <avr/signal.h>     // Deklarationen fr Interrupt
#include    <avr/interrupt.h>  // Deklarationen fr Interrupt
#include    "wartex10ms.c"     // wartet faktor*10ms Symbol TAKT
#include    "dual2bcd.c"       // dual nach BCD 
#include    "bcd2dual.c"       // BCD nach dual
volatile unsigned char zael=225,sekunde=0,minute=0,stunde=0; // global
// DCF77-Signal abtasten, Minute und Stunde dual speichern
void dcf77(void)
{
 static unsigned char liste[58], dummy, i;
 TCCR1B = 0xC4;         // 0b1100 0100 Timer1: Str ein, Flanke steigend, Takt/256
 while (!(PIND & (1 << ICP1)));        // warte solange Signal Low
 do
 {
  while (PIND & (1 << ICP1));          // warte solange Signal High
  TIFR |= (1 << ICF1);                 // Capture-Flag lschen durch 1
  TCNT1H = 0; TCNT1L = 0;              // Timer1 lschen
  while (! (TIFR & (1 << ICF1)));      // warte auf steigende Capture-Flanke
  dummy = ICR1L;                       // Low-Byte nicht auswerten
 } while (ICR1H < (19440/256));        // warte auf Synchronlcke
 // Synchronlcke erkannt alle Bits abspeichern
 for (i = 0; i < 58; i++)              // Signal abtasten und Bits speichern
 {
  while (PIND & (1 << ICP1));          // warte solange Signal High
  TIFR |= (1 << ICF1);                 // Capture-Flag lschen durch 1
  TCNT1H = 0; TCNT1L = 0;              // Timer1 lschen
  while (! (TIFR & (1 << ICF1)));      // warte auf steigende Capture-Flanke
  dummy = ICR1L;                       // Low-Byte nicht auswerten
  if (ICR1H < (12240/256)) liste[i] = 1; else liste[i] = 0; // Bit speichern
 } // Ende for-i speichern
 // Minute und Stunde auswerten
 minute = 0; 
 for (i = 0; i < 7; i++)               // Minute zusammensetzen
 {
  minute >>= 1; if (liste[i+21] == 1) minute |= 0x80; 
 } // Ende for-i Minute
 minute = bcd2dual(minute >>= 1);      // BCD nach dual umwandeln
 stunde = 0; 
 for (i = 0; i < 6; i++)               // Stunde zusammensetzen
 {
   stunde >>= 1; if (liste[i+29] == 1) stunde |= 0x80;
 } // Ende for-i Stunde
 stunde = bcd2dual(stunde >>= 2);      // BCD nach dual umwandeln
} // Ende dcf77

// Timer0 berlauf
SIGNAL (SIG_OVERFLOW0)                 // Service Timer0 berlauf 
{
 zael--; if (zael == 0)                // Interruptzhler Null ?
 {
  zael = 225; 
  sekunde++; if (sekunde == 60)        // Sekundenzhler voll ?
  {
   sekunde = 0;
   minute++; if (minute == 60)         // Minutenzhler voll ?
   {
    minute = 0;
    stunde++; if (stunde == 24) stunde = 0; // Stundenzhler
   } // Ende if-minute
  } // Ende if-sekunde
  PORTA = dual2bcd(sekunde);           // Sekunde dezimal ausgeben
  PORTB = dual2bcd(stunde);            // Stunde dezimal ausgeben
  PORTC = dual2bcd(minute);            // Minute dezimal ausgeben
 } // Ende if-zael
} // Ende Service

void main (void)                       // Hauptfunktion
{
 DDRA = DDRB = DDRC = 0xff;            // Ausgabe fr Ports A, B und C Port D Eingabe
 TCCR0 |= (1 << CS01) | (1 << CS00);   // 3686400 : Teiler 64 : 256 = 225 Hz
 TIMSK |=  (1 << TOIE0);               // Timer0 Interrupt frei
 wartex10ms(250);                      // 2500 ms = 2.5 sek warten
 dcf77();                              // Stunde und Minute auswerten
 sei();                                // I = 1 Interrupts global frei
 while (1)                             // Arbeitsschleife tut nix
 {   } // Ende while
} //Ende main


