

// k7p6.c  ATtiny2313 3.072 MHz  Stoppuhr mit Timer0
// Port B: Ausgabe BCD Hunderter und Zehner 
// Port D: PD0..PD3 BCD Einer  PD6 msek/sek  PD5:Start/Stopp  PD4: frei
#include <avr/io.h>                     // Deklarationen
#include <avr/interrupt.h>              // fr Interrupt
#include <avr/signal.h>                 // fr Interrupt
#define TAKT 3072000                    // 3.072 MHz: 256 = 12000:12 = 1000 Hz = 1 ms
unsigned int volatile sek=0, msek=0;      // globale Wort-Variable
unsigned char volatile  izaehl=1, fehl=0; // globale Byte-Variable
SIGNAL (SIG_TIMER0_OVF)                      // Timer0 berlauf
{ 
 izaehl++; if(izaehl > 12)                  // Interruptzhler
 {
  izaehl = 1; msek++;
  if(msek >= 1000) { msek=0; sek++; }      // Zhler erhhen
  if(sek >= 1000) fehl = 1;                 // berlauf-Fehlermarke setzen 
 } // Ende if izaehl
} // Ende Interruptfunktion
void main(void) 
{
 unsigned char aussekh, aussekl, ausmsekh, ausmsekl; 
 DDRB = 0xff;                           // Port B ist Ausgang
 DDRD = 0x0f;                           // Port D PD3..PD0 sind Ausgnge
 TIMSK |= 1 << TOIE0;                  // Timer0 Interrupt frei
 TCNT0 = 0;                             // Timer0 lschen
 while(PIND & (1 << PIND5));          // warte auf erste fallende Flanke PD5
 while(1)                              // Arbeitsschleife 
 {
  TCCR0B = 1 << CS00; sei();           // Timer0 start Taktteiler=1 Interrupt frei
  PORTB = 0xff; PORTD = 0x0f;          // Anzeige dunkel whrend der Messung
  while(!(PIND & (1 << PIND5)));      // warte auf steigende Flanke PD5
  TCCR0B = 0; cli();                    // Timer0 stopp Interrupt sperren
  aussekh =  ((sek/100) << 4) | (sek%100)/10;     // Sekunde Hunderter und Zehner
  aussekl = sek%10;                                 // Sekunde Einer
  ausmsekh =  ((msek/100) << 4) | (msek%100)/10;  // Millisekunde Hunderter und Zehner
  ausmsekl = msek%10;                               // Millisekunde Einer
  TCNT0 = 0; izaehl = 1; msek = 0; sek = 0;        // Zhler fr neuen Durchlauf lschen 
  while(PIND & (1 << PIND5))                      // warte auf fallende Flanke PD5
  {         
   if (fehl == 1) { PORTB = 0xcc; PORTD = 0x0c; }  // Fehlermarke U U U
   if (fehl == 0)                                   // kein Fehler: Zeit ausgeben
   { if (PIND & (1 << PIND6)) { PORTB = aussekh;  PORTD = aussekl;  }  // Sekunde
                         else { PORTB = ausmsekh; PORTD = ausmsekl; }  // Millisekunde
   } // Ende if 
  }  // Ende while warte fallende Flanke
 fehl = 0;                                         // Fehlermarke lschen
 } // Ende while Arbeitsschleife  
} // Ende main
