


// k7p5.c  AT90S2343 fr ATtiny12 Lotto und Wrfel
// Port B: B5:frei B4:Taster B5:Schalter B2:SCKL B1:RC B0:SERein
#include <io.h>                      // Deklarationen
#define lotto 49                     // Makrosymbol Lottozahlen
#define wuerfel 6                    // Makrosymbol Wrfel
unsigned char tab[10] = {0x3f,0x06,0x5b,0x4f,0x66,0x6d,0x7d,0x07,0x7f,0x6f};
void ausgabe(unsigned char zahl)     // dezimal seriell ausgeben
{
 unsigned char einer, zehner, i;     // lokale Hilfsvariablen
 unsigned int schieber;              // 16bit Schieberegister
 einer = tab[zahl % 10];              // Einer nach Siebensegmentcode
 zehner = tab[zahl / 10];             // Zehner nach Siebensegmentcode
 if (zehner == 0x3f) zehner = 0;     // fhrende Null durch Leerzeichen ersetzt 
 schieber = (unsigned int)einer << 8 | (unsigned int) zehner ; // MSB Einer Zehner LSB
 schieber = ~schieber;               // Komplement wegen Katodenansteuerung
 PORTB &= ~(1 << PB1);               // RCK bernahmetakt Low
 for (i=1; i<=16; i++)               // Schiebeschleife
 {
  PORTB &= ~(1 << PB2);             // SCKL Schiebetakt Low
  if((schieber & 0x8000) == 0x8000) PORTB |= (1 << PB0); else PORTB &= ~(1 << PB0); // Bitausgabe
  schieber = schieber << 1;          // nchstes Bit schieben 
  PORTB |= (1 << PB2);              // SCKL Schiebetakt steigende Flanke
 } // Ende for
 PORTB |= (1 << PB1);               // RCK bernahmetakt steigende Flanke
} // Ende ausgabe

void main(void)                      // Hauptfunktion
{
 unsigned char i, iend;             // Zhler und Zhlerendwert
 DDRB = 0x07;                        // 0000 0111 PB2 PB1 BB0 Portausgnge
 while(1)                           // Arbeitsschleife
 {
  if(! (PINB & (1 << PB4))) iend = wuerfel; else iend = lotto;
  for(i=1; i<=iend; i++)             // Zahlen von 1 bis ...erzeugen
  {   
   ausgabe(i);                       // laufenden Wert ausgeben
   if(!(PINB & ( 1 << PB3))) while (! (PINB & (1 <<PB3))); // Stopp-Taste?
  }  // Ende for
 } // Ende while
} // Ende main