


// k7p3.c   Mega8515 am PC-Terminal mit externem SRAM ein 32 kByte Baustein 
// Port A: SRAM-Adressen/Daten AD0.. AD7
// Port C: SRAM-Adressen A8..A15
// Port B: Eingabe frei fr Testwerte
// Port D: PD0=RxD PD1=TxD PD6=/WR PD7=/RD D2=INT0  D3 D4 D5 frei 
// PORT E: E1=ALE  E0 E2 frei
#include <io.h>                                  // Deklarationen
#define TAKT 8000000UL                           // Takt
#define BAUD 9600UL                              // Baudrate
#define RAMENDE 0x0260                           // Anfang ext. SRAM
#include "c:\cprog3\konsolfunc.h"                // initusart,putch,getch,getche,kbhit
#include "c:\cprog3\putstring.c"                 // USART String senden
#include "c:\cprog3\ahex8.c"                     // USART Byte hexa ausgeben
#include "c:\cprog3\ahex16.c"                    // USART Wort hexa ausgeben
unsigned char  *zeiger = (unsigned char *) RAMENDE; // Zeiger auf SRAM-Anfang
void main(void)                                 // Hauptfunktion
{
 unsigned int adress;                           // laufende SRAM-Adresse
 unsigned char wert, rueck;                     // Hilfsvariablen
 initusart();                                    // USART initialisieren
 MCUCR |= (1<<SRE) ;                             // ext. SRAM ein kein Wartetakt  
 while(1)                                       // Arbeitsschleife
 {
  zeiger = (unsigned char *) RAMENDE;           // Zeiger auf SRAM-Anfang 
  wert = 0;                                       // Testwert mod 256
  for(adress=RAMENDE; adress <= 0x825F; adress++) // SRAM-Bereich testen mit 0-255 
  {
   *zeiger = wert;                               // Testwert einschreiben
   rueck = *zeiger;                              // und rcklesen
   if (rueck != wert)                            // bei ungleich: Fehlermeldung
   {
    putstring("\n\rSRAM-Fehler: "); putch('0'); putch('x'); ahex16(adress); putch(' ');
    putch('0'); putch('x'); ahex8(wert); putch('#');putch('0'); putch('x'); ahex8(rueck);
    getch();                                          // warte auf Taste
   } // Ende if 
   zeiger++; wert++;                                 // nchste Adresse nchster Wert
  } // Ende for test
  putstring("\n\rRAM getestet");
  zeiger = (unsigned char *) RAMENDE;               // Zeiger auf SRAM-Anfang 
  for(adress=RAMENDE; adress <= 0x825F; adress+=16) // SRAM-Bereich ausgeben
  {
   putch(10);putch(13);putch('0');putch('x'); ahex16(adress);  // Adresse
   for(unsigned char i=1;i<=16;i++) {putch(' '); putch('x'); ahex8(*zeiger++); } // 16 Werte
  getch();                                           // warte auf Taste
  } // Ende for Ausgabe
   } // Ende while
} // Ende main