

// k6p9.c  ATmega8  Tongenerator  Frequenz mit Poti einstellen
// Port B: Ausgabe Hunderter PB1=OC1A Signalausgabe
// Port C: Analoge Eingabe PC0 Poti 47 kOhm
// Port D: Ausgabe Zehner Einer des Ladewerts
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include <avr/io.h>    // Deklarationen
void main(void)       // Hauptfunktion
{
 long int summe;
 unsigned int zaehl;
 DDRB = 0xff;          // 1111 1111 Port B ist Ausgang
 DDRD = 0xFf;          // 0000 1111 Port D ist Ausgang
 ADMUX = (0  << REFS1) | (1 << REFS0); // 0100 0000 AVCC Referenz rechtsbndig PC0
 ADCSRA = (1 << ADEN) | (1 << ADSC) | (1<< ADPS1) | (1 << ADPS0); // AD-Wandler
 TCCR1A = (1 << COM1A0);               // Timer1 OC1A bei match umschalten
 TCCR1B = (1 << WGM12) | (1 << CS10); // Timer1 lschen Taktteiler:1
 summe = 0; zaehl = 0;                 // Summe und Zhler lschen
 while(1)                              // Arbeitsschleife
 {
  while( ADCSRA & (1 << ADSC));        // warte auf Ende der Wandlung
  summe = summe + (long int) ADCL + ((long int) ADCH << 8);  
  zaehl++; if (zaehl >= 256)           // 256 Werte zhlen
  {
   summe = summe >> 8;                 // Low-Byte verwerfen Division durch 256 
   OCR1A = summe;                      // Compareregister laden
   PORTD = ((( summe % 100) / 10) << 4) | ((summe % 100) % 10); // Zehner und Einer
   PORTB = (summe / 100) << 4;         // Hunderter
   zaehl = 0; summe = 0;               // Zhler und Summe lschen
   } // Ende if
  sbi(ADCSRA,ADSC);                    // Wandler neu starten
 } // Ende while
} // Ende main