

// k6p6.c  ATmega8  Ref 2.56 V intern  8bit Mittel 256 Messungen
// Port B: Ausgabe Zehner und Einer
// Port C: Analoge Eingabe +5V-3.5k- ADC0 -1kPoti-1.5k-AGND
// Port D: Ausgabe Hunderter
// Konfiguration: interner Oszillator 1 MHz, externes Reset-Signal
#include <avr/io.h>    // Deklarationen
void main(void)       // Hauptfunktion
{
 long int summe;
 unsigned int zaehl;
 DDRB = 0xff;          // 1111 1111 Port B ist Ausgang
 DDRD = 0x0f;          // 0000 1111 Port D3-D0 ist Ausgang
 ADMUX = (1  << REFS1) | (REFS0);   // 1100 0000 2.56 V Referenz rechtsbndig PC0
 ADCSRA = (1 << ADEN) | (1 << ADSC) | (1<< ADPS1) | (1 << ADPS0);
 summe = 0; zaehl = 0;              // Summe und Zhler lschen
 while(1)                           // Arbeitsschleife
 {
  while( ADCSRA & (1 << ADSC));    // warte auf Ende der Wandlung
  summe = summe + (long int) ADCL + ((long int) ADCH << 8);             
  zaehl++; if (zaehl >= 256)        // 256 Werte zhlen
  {
   summe = summe >> 10;              // nur 8bit der Summe dezimal ausgeben 
   PORTB = ((( summe % 100) / 10) << 4) | ((summe % 100) % 10); // Zehner und Einer
   PORTD = summe / 100;             // Hunderter
   zaehl = 0; summe = 0;            // Zhler und Summe lschen
   }
  sbi(ADCSRA,ADSC);                 // Wandler neu starten
 } // Ende while
} // Ende main

