

// k6p4.c ATmega8 LCD-Anzeige und Tastatur
// Port B: LCD-Anzeige: PB1: E-Signal
// Port D: LCD-Anzeige: PD7 PD6 PD5 PD4 (4bit)   PD3: RS-Signal
#include <io.h>                  // Deklarationen
#define TAKT 8000000ul           // Systemtakt Quarz 8 MHz
// Symboldefinitionen fr LCD-Schnittstelle 4bit Bus an High-Port
#define LCDPEN PORTB             // Port des E-Signals
#define LCDEN  PB1               // Bit E Freigabsignal 
#define LCDPRS PORTD             // Port des RS-Signal
#define LCDRS  PD3               // Bit RS Registerauswahlsignal
#define LCDPDAT PORTD            // Port des 4bit-Datenbus
#define LCDBUS 'h'               // Anschluss an High-Port PB7..PB4
unsigned char curpos = 0;        // globale Cursorposition 
// externe LCD- und Tastaturfunktionen
#include  "lcd4.h"               // fgt warte1ms und LCD-Funktionen ein
#include  "tastatur.c"           // Funktionen taste und eintas
//
void main(void)                  // Hauptfunktion
{
 unsigned char meldung [] = "   Willkommen   >";  // Prompt Meldung
 DDRD = 0xf8;                    // 1111 1000 PD7 - PD3 sind Ausgnge
 LCDPEN &= ~(1 << LCDEN);        // PB1 Datenausgang LOW
 DDRB   |=  (1 << LCDEN);        // PB1 ist Ausgang fr LCD-/E-Signal
 lcd4ini();                      // LCD-Anzeige initialisieren
 lcd4puts(meldung);              // Meldung: Willkommen   >
 while(1)
 {
  unsigned char code;
  code = eintas();               // warte bis Taste gelst
  if (code >= 0x20) lcd4put(code);  else lcd4func(code); // Ausgabe
 } // Ende while
} // Ende main
