

// k4p23.c  ATmega8 AD-Wandler Dauerbetrieb Interrupt
// Port B: Ausgabe dual Bit_9 Bit_8
// Port D: Ausgabe dual Bit_7..Bit_0
// Port C: Eingabe ADC0 Potentiometer
// Konfiguration: interner Oszillator 1  MHz, externes Reset-Signal
#include <avr/io.h>         // Deklarationen
#include <avr/signal.h>     // Interrupt-Deklarationen
#include <avr/interrupt.h>  // Interrupt-Deklarationen
SIGNAL(SIG_ADC)             // Interrupt-Service AD-Wandler
{
 PORTD = ADCL;     // Low-Teil ausgeben
 PORTB = ADCH;     // High-Teil ausgeben
}
void main(void)   // Hauptfunktion
{
 DDRB = 0xff;      // Port B ist Ausgang
 DDRD = 0xff;      // Port D ist Ausgang
 ADMUX = (0 << REFS1) | (0 << REFS0) | (0 << ADLAR) | (0 <<  MUX1) | (0 << MUX0);
 ADCSRA = (1<< ADEN) |( 1<< ADSC) | (1<<ADFR) | (1<<ADIE) | (1<<ADPS1) | (1<<ADPS0);
 sei();            // Interrupts global frei
 while(1) { }     // Arbeitsschleife leer 
} // Ende main
