

// k4p11.c  ATmega8  Timer2 Sekundenzhler
// Port D: Ausgabe Sekunden 00 bis 59
// Port B: Quarz 32768 kHz an TOsC1 (PB6) und TOSC2 (PB7)
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>            // Deklarationen
#include <avr/signal.h>        // fr Interrupt
#include <avr/interrupt.h>     // fr Interrupt
#define TAKT 1000000UL         // Systemtakt intern ca. 1 MHz
volatile unsigned char  seku=0;    // globale Variable
SIGNAL (SIG_OVERFLOW2)        // bei Timer2 berlauf
{
 seku++;
 if (seku == 60) seku = 0;   // Sekunde mod 60 
 PORTD = ((seku/10) << 4) | (seku % 10);  // BCD ausgeben
} // Ende SIGNAL

void main(void)              // Hauptfunktion kein Aufruf von SIGNAL!!!
{
 DDRD = 0xff;                 // Port B Richtung Ausgabe
 PORTD = seku;                // auf Port B ausgeben
 ASSR  |= (1 << AS2);        // asynchron mit ext. Takt
 TCCR2 |= (1 << CS22) | (1 << CS20);    // Teiler Systemtakt :128
 TIMSK |= (1 << TOIE2);      //  Timer2 Interrupt frei 
 sei();                       // alle Interrupts frei
 while(1) { }                // Arbeitsschleife durch Interrupt unterbrochen
} // Ende main


