

// k3p14.c  ATmega8 Dynamische Felder 
// PORTB: Ausgabe Marke und Sekundenzhler 0 .. 9
// PORTD: -
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>         // Vereinbarungen
#include <stdlib.h>         // Speicherverwaltungsfunktionen
#define TAKT 1000000        // Controllertakt ca. 8 MHz
#include "wartex10ms.c" // wartet n * 10 ms
#define N 10                // Symbold fr Anzahl der Werte
void main(void)            // Hauptfunktion
{
 char *p=NULL,*z=NULL;     // Zeiger mit Null-Marke vorbesetzt
 unsigned int i;           // Laufvariable
 DDRB = 0xff;               // Port B ist Ausgang
 while(1)                   // Testschleife
 {  
  p = malloc(N * sizeof(char) );                 // Speicher zuweisen
  if (p != NULL) PORTB=0x55; else PORTB = 0xaa;  // gelungen ?
  wartex10ms(200);                                 // 2 sek warten
  for (i=0; i<N; i++) *(p+i) = i;                // besetzen
  for (i=0; i<N; i++) { PORTB = *(p+i); wartex10ms(100); } //  ausgeben
  free(p);                                         // freigeben
  z = calloc(N, sizeof(char));                   // Speicher mit 0 besetzt
  if (z != NULL) PORTB=0x55; else PORTB = 0xaa;  // gelungen ?
  wartex10ms(200);                                 // 2 sek warten
  for (i=0; i<N; i++) *(z+i) = *(z+i) + i;       // besetzen
  for (i=0; i<N; i++) { PORTB = *(z+i); wartex10ms(100); }  // ausgeben
  free(z);                                         // freigeben
 } // Ende while 
} // Ende main
