

; test7.asm Test Software-Multiplikation und Division
; Port B: Ausgabe 
; Port D: Eingabe 
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    takt = 8000000  ; Takt 8 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .LISTMAC                ; Makrolisting ein
; Makrodefinitionen
        .INCLUDE "Mmul16.asm"   ; Hardware-Multiplikation R3:R2:R1:R0 <- @0:@1 * @2:@3
        .INCLUDE "Mdivx8.asm"   ; Software-Division
        .INCLUDE "Mdivx16.asm"  ; Software-Division
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Endadresse_Low SRAM
        out     SPL,akku        ; nach Stapelzeiger_Low
        ldi     akku,HIGH(RAMEND) ; Endadresse_High SRAM
        out     SPH,akku        ; nach Stapelzeiger_High
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Richtung Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
        out     DDRD,akku       ; Port D ist Ausgang
; Test 8bit Division  R1 / R0
        ldi     ZL,0            ; Testwerte vorbesetzen
        ldi     ZH,0            ;
loop:   mov     r1,ZL           ; ZL = R1 = Dividend
        mov     r0,ZH           ; ZH = R0 = Divisor 
        out     PORTB,r1        ; PORTB <- Dividend
        out     PORTC,r0        ; PORTC <- Divisor
        rcall   divx8           ; R1 / R0  R1<-Quot  R0<-Rest
        movw    r17:r16,r1:r0   ; R17 = Quot R16 = Rest
        mul     r17,ZH          ; R1:R0 <- Produkt Quotient * Divisor
        add     r0,r16          ; + Rest
        cp      r0,ZL           ; Quotient*Divisor+Rest - Dividend
        brne    error           ; Rckrechnung ungleich:Fehler
        adiw    ZL,1            ; Dividend erhhen bzw. auch Divisor
        brne    loop            ;
; Test 16bit Division  R3:R2 / R1:R0
test16:
        ldi     ZL,0            ; Testwerte vorbesetzen
        ldi     ZH,0            ;
        ldi     YL,0            ;
        ldi     YH,0            ;
loop1:  movw    r3:r2,YH:YL     ; Dividend
        movw    r1:r0,ZH:ZL     ; Divisor
        out     PORTB,r3        ; PORTB <- Dividend_High
        out     PORTC,r1        ; PORTC <- Divisor_High
        out     PORTD,r0        ; PORTD <- Dividor_Low
        rcall   divx16          ; R3:R2 <- Quotient  R1:R0 <- Rest
        movw    r19:r18,r3:r2   ; R19:R18 <- Quotient
        movw    r17:r16,ZH:ZL   ; R17:R16 <- Divisor
        movw    r21:r20,r1:r0   ; R21:r20 <- Rest
        rcall   mul16           ; R3:R2:R1:R0 <- Quotient * Divisor
        add     r0,r20          ; + Rest_Low
        adc     r1,r21          ; + Rest_High
        cp      r0,YL           ; Dividend_Low
        cpc     r1,YH           ; Dividend_High
        brne    error           ; Rckrechnung ungleich: Fehler
        adiw    YL,1            ; Dividend erhhen
        brne    loop1           ;
        adiw    ZL,1            ; Divisor erhhen
        rjmp    loop1




error:  rjmp    PC
; Unterprogramme
        .INCLUDE "warte20ms.asm";
        .INCLUDE "mul16.asm"    ; Hardware R3:R2:R1:R0 <- R19:R18 * R17:R16
        .INCLUDE "divx8.asm"    ; Software-Division R1 / R0   R1 <- Quot  R0 <- Rest
        .INCLUDE "divx16.asm"   ; Software-Division R3:R2 / R1:R0   R3:R2 <- Quotient  R1:R0 <- Rest
        .EXIT                   ; Ende des Quelltextes

