

; k7p9.asm ATmega16 DCF77-Uhr
; Port A: Sekunde dezimal
; Port B: Stunde dezimal
; Port C: Minute dezimal
; Port D: D6: ICP1=DCF77
; Konfiguration Quarz 3.6864 MHz  JTAG Interface disabled!
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    ICP1 = PD6      ; 
        .EQU    takt = 3686400  ; Takt 3.6864 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    zael = r19      ; Interruptzhler
        .DEF    sekunde = r20   ; Sekunde
        .DEF    minute = r21    ; Minute 
        .DEF    stunde = r22    ; Stunde 
        .DEF    eins = r23      ; Zhl-Eins
        .DEF    null = r24      ; Lsch-Null
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    OVF0addr        ; Einsprung Timer0 berlauf
        rjmp    tictac          ; Uhr und Anzeige umschalten
        .ORG    $2A             ; 
start:  ldi     akku,LOW(RAMEND); Endadresse_Low SRAM
        out     SPL,akku        ; nach Stapelzeiger_Low
        ldi     akku,HIGH(RAMEND) ; Endadresse_High SRAM
        out     SPH,akku        ; nach Stapelzeiger_High
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRA,akku       ; A7-A0 Ausgang
        out     DDRB,akku       ; B7-B0 Ausgang
        out     DDRC,akku       ; C7-C0 Ausgang
        ldi     eins,1          ; Zhl-Eins
        clr     null            ; Lsch-Null
        ldi     zael,225        ; Interruptzhler 225 Hz
; Timer0 vorbereiten
        in      akku,TCCR0      ; Steuerregister Timer0
        ori     akku,(1 << CS01) | (1 << CS00); Mode 011 Teiler 64 
        out     TCCR0,akku      ; 3686400 : 64 : 256 = 225 Hz
        in      akku,TIMSK      ; Steuerregister Timerinterrupt
        ori     akku,(1 << TOIE0); Timer0 Interrupt frei
        out     TIMSK,akku      ;
        ldi     r16,250         ; R16 = Faktor 250
        rcall   wartex10ms      ; wartet 2500 ms = 2.5 sek
        rcall   dcf77           ; R16 = Stunde  R17 = Minute
        mov     stunde,r16      ;
        mov     minute,r17      ;
        clr     sekunde         ; 
        out     PORTA,sekunde   ; Startwerte ausgeben
        out     PORTC,minute    ;
        out     PORTB,stunde    ; 
        sei                     ; I = 1 Interrupts global frei
; Arbeitsschleife 
loop:   nop                     ;
        rjmp    loop            ; Kontrollschleife
;
; Interrupt 225 Hz  4.44 ms
tictac: push    r16             ; Register retten
        in      r16,SREG        ; Status
        push    r16             ;
        dec     zael            ; Interruptzhler vermindern
        brne    tictacx         ; ungleich Null:
        ldi     zael,225        ;   gleich Null: Anfangswert
; 1 Sekunde vergangen
        mov     r16,sekunde     ;
        add     r16,eins        ; Sekunde erhhen
        rcall   daa             ; BCD-Korrektur
        mov     sekunde,r16     ; Sekunde erhht 
        cpi     sekunde,$60     ; Minute voll
        brlo    tictac1         ; nein:
        clr     sekunde         ;   ja: Sekunde lschen
; 1 Minute vergangen
        mov     r16,minute      ; Minute
        add     r16,eins        ; erhhen
        rcall   daa             ; Dezimalkorrektur
        mov     minute,r16      ;
        cpi     minute,$60      ; Stunde voll ?
        brlo    tictac1         ; nein:
        clr     minute          ; ja: Minute lschen
; 1 Stunde vergangen
        mov     r16,stunde      ; Stunde 
        add     r16,eins        ; erhhen
        rcall   daa             ; Dezimalkorrektur
        mov     stunde,r16      ;
        cpi     stunde,$24      ; Tag voll ?
        brlo    tictac1         ; nein:
        clr     stunde          ;   ja: ein neuer Tag beginnt
; Zeit ausgeben
tictac1:out     PORTA,sekunde   ; ausgeben
        out     PORTC,minute    ;
        out     PORTB,stunde    ; 
; Rcksprung
tictacx:pop     r16             ; Register zurck
        out     SREG,r16        ; Status
        pop     r16             ;
        reti                    ;
;
; dcf77 liefert R16 = Stunde  R17 = Minute  
dcf77:  push    r15             ; Register retten
        push    r18             ;
        push    XL              ;
        push    XH              ;
        ldi     XL,LOW(liste)   ; Anfangsadresse
        ldi     XH,HIGH(liste)  ; Bitspeicher
        ldi     r18,58          ; Bit-Zhler
        ldi     r16,0b11000100  ; Str ein, Flanke stei, Takt/256
        out     TCCR1B,r16      ; Timer1 Capture-Steuerung
        clr     r17             ; R17 = Synchronisationsmarke lschen
; Synchronisationsbit suchen
dcf77a: sbis    PIND,ICP1       ; berspringe bei High
        rjmp    dcf77a          ; warte bei Low
dcf77b: sbic    PIND,ICP1       ; berspringe bei Low
        rjmp    dcf77b          ; warte bei High
; fallende Flanke erkannt
        in      r16,TIFR        ; Timer-Interrupt Anzeige
        sbr     r16,ICF1        ; Capture-Flag lschen durch 1
        out     TIFR,r16        ; einschreiben
        out     TCNT1H,null     ; Timer1 High lschen
        out     TCNT1L,null     ; dann Low
dcf77c: in      r16,TIFR        ; R16 <- Timer-Interrupt-Anzeige
        sbrs    r16,ICF1        ; berspringe bei gesetzt
        rjmp    dcf77c          ; warte auf steigende Flanke
        in      r16,ICR1L       ; erst Low nicht auswerten
        in      r16,ICR1H       ; dann High
        tst     r17             ; Synchronisation schon gefunden ?
        brne    dcf77d          ; Marke ungleich Null: ja: speichern
        cpi     r16,HIGH(19440) ; nein: Zeit fr Startbit ?
        brlo    dcf77b          ; nein: warten
        com     r17             ;   ja: R17=$FF Synchronisation erkannt
        rjmp    dcf77b          ; weiter abtasten
; Startbit gefunden alle Folge-Bits speichern
dcf77d: cpi     r16,HIGH(12240) ; Bit High oder Low ?
        brlo    dcf77e          ; kleiner: High-Bit
        ldi     r16,0           ; grsser: Low-Bit
        rjmp    dcf77f          ;
dcf77e: ldi     r16,1           ; kleiner: High-Bit
dcf77f: st      X+,r16          ; speichern Adresse + 1
        dec     r18             ; Zhler - 1
        brne    dcf77b          ;
; Auswertung R16 = Stunde  R17 = Minute
        ldi     XL,LOW(liste+21)   ; Anfangsadresse Liste
        ldi     XH,HIGH(liste+21)  ; niedrigstes Minutenbit
        ldi     r18,7           ; R18 = Bitzhler
        clr     r17             ; Minute lschen
dcf77g: ld      r15,X+          ; Bit laden
        lsr     r15             ; nach Carry
        ror     r17             ; nach Minute
        dec     r18             ; Zhler - 1
        brne    dcf77g          ;
        lsr     r17             ; R17 = Minute
        ld      r15,X+          ; Parittsbit bergehen
        ldi     r18,6           ; R18 = Bitzhler
        clr     r16             ; Stunde lschen
dcf77h: ld      r15,X+          ; Bit laden
        lsr     r15             ; nach Carry
        ror     r16             ; nach Stunde
        dec     r18             ; Zhler - 1
        brne    dcf77h          ;
        lsr     r16             ; R16 = Stunde
        lsr     r16             ; 
        pop     XH              ; Register zurck
        pop     XL              ;
        pop     r18             ;
        pop     r15             ; 
        ret                     ;
;
        .INCLUDE  "daa.asm"     ; Dezimalkorrektur in R16
        .INCLUDE  "wartex10ms.asm" ; warte R16*10ms Symbol takt
;
; Speicher fr 58 Abtastungen nach Synchronisationsbit
        .DSEG                   ; SRAM
liste:  .BYTE     58            ; 58 Bytes reserviert
        .EXIT                   ; Ende des Quelltextes

