

; k7p8.asm ATmega16 4stellige LCD-Anzeige
; Port A: A7 = Eingang Std+   A6-A0 = Ausgang Stelle links
; Port B: B7 = Ausgang COL    B6-B0 = Ausgang Stelle mitte links
; Port C: C7 = Ausgang BP     C6-C0 = Ausgang Stelle mitter rechts
; Port D: D7 = Eingang Min+   D6-D0 = Ausgang Stelle rechts
; Konfiguration Quarz 3.6864 MHz  JTAG Interface disabled!
        .INCLUDE "m16def.inc"   ; Deklarationen fr ATmega16
        .EQU    takt = 3686400  ; Takt 3.6864 MHz
        .DEF    akku = r16      ; Arbeitsregister
        .DEF    combit7 = r18   ; EORI-Maske Komplement Bit_7
        .DEF    zael = r19      ; Interruptzhler
        .DEF    sekunde = r20   ; Sekundenzhler
        .DEF    minute = r21    ; Minute 
        .DEF    stunde = r22    ; Stunde 
        .DEF    eins = r23      ; Zhl-Eins
        .DEF    s1 = r2         ; Ausgabe niedrigste Stelle rechts
        .DEF    s2 = r3         ; Ausgabe mitte rechts
        .DEF    s3 = r4         ; Ausgabe mitte links
        .DEF    s4 = r5         ; Ausgabe hchste Stelle links
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    OVF0addr        ; Einsprung Timer0 berlauf
        rjmp    tictac          ; Uhr und Anzeige umschalten
        .ORG    $2A             ; 
start:  ldi     akku,LOW(RAMEND); Endadresse_Low SRAM
        out     SPL,akku        ; nach Stapelzeiger_Low
        ldi     akku,HIGH(RAMEND) ; Endadresse_High SRAM
        out     SPH,akku        ; nach Stapelzeiger_High
        ldi     akku,$7f        ; Bitmuster 0111 1111
        out     DDRA,akku       ; A7 Eingang  A6-A0 Ausgang
        out     DDRD,akku       ; D7 Eingang  D6-D0 Ausgang
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; B7-B0 Ausgang
        out     DDRC,akku       ; C7-C0 Ausgang
        clr     sekunde         ; Sekunde lschen
        clr     minute          ; Minute lschen
        clr     stunde          ; Stunde lschen
        ldi     eins,1          ; Zhl-Eins
        ldi     combit7,$80     ; EORI-Maske 1000 0000 
        ldi     zael,225        ; Interruptzhler 225 Hz
        rcall   anzeig          ; Anzeige codieren und ausgeben
; Timer0 vorbereiten
        in      akku,TCCR0      ; Steuerregister Timer0
        ori     akku,(1 << CS01) | (1 << CS00); Mode 011 Teiler 64 
        out     TCCR0,akku      ; 3686400 : 64 : 256 = 225 Hz
        in      akku,TIMSK      ; Steuerregister Timerinterrupt
        ori     akku,(1 << TOIE0); Timer0 Interrupt frei
        out     TIMSK,akku       ;
        sei                     ; I = 1 Interrupts global frei
; Arbeitsschleife kontrolliert Taster PD7 und PA7
loop:   sbic    PIND,PD7        ; berspringe bei PD7 Low
        rjmp    loop2           ; warte solange PD7 High
        rcall   minplus         ; fallende Flanke Minute +1
        rcall   anzeig          ; und anzeigen
        rcall   warte20ms       ; entprellen
loop1:  sbis    PIND,PD7        ; berspringe bei PD7 High
        rjmp    loop1           ; warte solange PD7 Low
        rcall   warte20ms       ; steigende Flanke entprellen
loop2:  sbic    PINA,PA7        ; berspringe bei PA7 Low
        rjmp    loop            ; warte solange PA7 High
        rcall   stuplus         ; fallende Flanke Stunde +1
        rcall   anzeig          ; und anzeigen
        rcall   warte20ms       ; entprellen
loop3:  sbis    PINA,PA7        ; berspringe bei PA7 High
        rjmp    loop3           ; warte solange PA7 Low
        rcall   warte20ms       ; entprellen
        rjmp    loop            ; Kontrollschleife
;
; Interrupt 225 Hz  4.44 ms
tictac: push    r16             ; Register retten
        in      r16,SREG        ; Status
        push    r16             ;
        com     s1              ; Ausgabe
        com     s2              ; komplementieren
        com     s3              ;
        com     s4              ;
        out     PORTA,s4        ; links
        out     PORTB,s3        ; links mitte
        out     PORTC,s2        ; rechts mitte
        out     PORTD,s1        ; rechts
        dec     zael            ; Interruptzhler vermindern
        brne    tictacx         ; ungleich Null:
        ldi     zael,225        ;   gleich Null: Anfangswert
; 1 Sekunde vergangen
        mov     r16,s3          ; Doppelpunkt
        eor     r16,combit7     ; komplementieren
        mov     s3,r16          ;
        inc     sekunde         ; Sekunde erhhen dual
        cpi     sekunde,60      ; Minute voll
        brlo    tictacx         ; nein:
        clr     sekunde         ;   ja: Sekunde lschen
        rcall   minplus         ; Minute und Stunde erhhen
        rcall   anzeig          ; Anzeige codieren und ausgeben
; Rcksprung
tictacx:pop     r16             ; Register zurck
        out     SREG,r16        ; Status
        pop     r16             ;
        reti                    ;
;
; Minute erhhen R16 nicht gerettet
minplus:mov     r16,minute      ; Minute
        add     r16,eins        ; erhhen
        rcall   daa             ; Dezimalkorrektur
        mov     minute,r16      ;
        cpi     minute,$60      ; Stunde voll ?
        brlo    minplusx        ; nein:
        clr     minute          ; ja: Minute lschen
; Einsprung Stunde erhhen R16 nicht gerettet
stuplus:mov     r16,stunde      ; Stunde 
        add     r16,eins        ; erhhen
        rcall   daa             ; Dezimalkorrektur
        mov     stunde,r16      ;
        cpi     stunde,$24      ; Tag voll ?
        brlo    minplusx        ; nein:
        clr     stunde          ;   ja: neuer Tag
minplusx:ret                    ; R16 nicht gerettet
;
; Zeit codiern und anzeigen 
anzeig: push    r16             ; Register retten
        mov     r16,minute      ; Minute ausgeben
        andi    r16,$0f         ; Maske 0000 1111
        rcall   umcod           ; R16 BCD nach Siebensegment
        mov     s1,r16          ; Einer Minute
        mov     r16,minute      ; 
        swap    r16             ;
        andi    r16,$0f         ; Maske 0000 1111
        rcall   umcod           ; R16 BCD nach Siebensegment
        cpi     r16,$3f         ; fhrende Null ?
        brne    anzeig1         ; nein:
        clr     r16             ;   ja: Leerzeichen
anzeig1:mov     s2,r16          ; Zehner Minute
        mov     r16,stunde      ; Stunde ausgeben
        andi    r16,$0f         ; Maske 0000 1111
        rcall   umcod           ; R16 BCD nach Siebensegment
        mov     s3,r16          ; Einer Stunde
        mov     r16,stunde      ; 
        swap    r16             ;
        andi    r16,$0f         ; Maske 0000 1111
        rcall   umcod           ; R16 BCD nach Siebensegment
        cpi     r16,$3f         ; fhrende Null ?
        brne    anzeig2         ; nein:
        clr     r16             ;   ja: Leerzeichen
anzeig2:mov     s4,r16          ; Zehner Stunde
        pop     r16             ; Register zurck
        ret                     ;
;
; Codieren R16 = BCD nach R16 = Siebensegmentcode
umcod:  push    ZH              ; Register retten
        push    ZL              ;
        ldi     ZL,LOW(ctab*2)  ; Z mit Tabellenadresse laden
        ldi     ZH,HIGH(ctab*2) ;
        add     ZL,r16          ; Abstand addieren
        clr     r16             ; Carry bleibt
        adc     ZH,r16          ; + bertrag
        lpm     r16,Z           ; Siebensegmentcode laden
        pop     ZL              ; Register zurck
        pop     ZH              ;
        ret                     ;
; Codetabelle
ctab:   .DB $3F,$06,$5B,$4F,$66,$6D,$7D,$07,$7F,$6F ; Ziffern 0 ... 9
        .DB $77,$7C,$39,$5E,$79,$71                 ; A b C d E F
        .INCLUDE  "daa.asm"     ; Dezimalkorrektur in R16
        .INCLUDE  "warte20ms.asm" ; warte 20 ms Symbol takt
        .EXIT                    ; Ende des Quelltextes

