


; k7p3.asm ATmega8515 mit externem SRAM und PC-Terminal
; Port A: SRAM-Adressen/Daten AD0..AD7 
; Port C: SRAM-Adressen A8..A15 
; Port D: PD0:RxD PD1:TxD PD6:/WR PD7:/RD
        .INCLUDE "m8515def.inc"  ; Portdeklarationen
        .INCLUDE "Mkonsole.h"    ;
        .EQU    baud = 9600      ; Baudrate
        .EQU    takt = 8000000   ; Controllertakt
        .DEF    akku = r16       ; Arbeitsregister
        .DEF    hilf = r17       ; Hilfsregister zum Rcklesen
        .DEF    wert = r18       ; Testwert
        .CSEG                    ; Programmsegment
        rjmp    start            ; Reset-Einsprung
        .ORG    $11              ; Interrupteinsprnge bergangen
start:  ldi     akku,LOW(RAMEND) ; Endadresse des internen SRAM
        out     SPL,akku         ; 512  Bytes 
        ldi     akku,HIGH(RAMEND); Stapel anlegen
        out     SPH,akku         ;
        rcall   initusart        ; USART intialisieren
; externen SRAM freigeben mit Wartetakt und testen
        in      akku,MCUCR       ; 
        ori     akku,(1<<SRE)    ; ext. SRAM  kein Wartetakt 
        out     MCUCR,akku       ;
; SRAM mit laufenden Zhler testen
test0:  ldi     YL,LOW(RAMEND+1) ; Y <= Anfangsadresse 
        ldi     YH,HIGH(RAMEND+1); des externen SRAM
        clr     wert
test1:  st      Y,wert           ; Testwert schreiben
        nop                      ; Pause der Ergriffenheit
        nop                      ;
        ld      hilf,Y           ; und rcklesen
        cpse    wert,hilf        ; berspringe wenn beide gleich 
        rjmp    fehler           ; ungleich: Fehlermeldung
test2:  inc     wert             ;
        adiw    YL,1             ; Adresse + 1
        cpi     YH,$82           ; Schleifenkontrolle
        brne    test1            ; bis $825F
        cpi     YL,$60           ;
        brne    test1            ;
        ldi     ZL,LOW(gut*2)    ; Z <= Adresse
        ldi     ZH,HIGH(gut*2)   ; Meldung SRAM gut
        rcall   puts             ; nach Terminal
; SRAM hexadezimal ausgeben
        ldi     YL,LOW(RAMEND+1) ; Y <= Anfangsadresse 
        ldi     YH,HIGH(RAMEND+1); des externen SRAM
test3:  rcall   aus16            ; Endlosschleife
        adiw    YL,16            ; testet auch 
        rcall   getch            ; Adresse > $825F !!!
        rjmp    test3            ; 
; Speicherfehler erkannt
fehler: ldi     ZL,LOW(err*2)    ; Z <= Adresse
        ldi     ZH,HIGH(err*2)   ; Fehlermeldung
        rcall   puts             ; ausgeben
        mov     akku,YH          ;
        rcall   aushex8          ;
        mov     akku,YL          ;
        rcall   aushex8a         ; 
        mov     akku,hilf        ; Istwert
        rcall   aushex8          ; hexadezimal ausgeben
        ldi     akku,' '         ; lz
        rcall   putch             ;
        ldi     akku,$23         ; #
        rcall   putch            ; ausgeben
        mov     akku,wert        ; Sollwert
        rcall   aushex8          ; ausgeben
        rcall   getch            ; warte auf Taste
        rjmp    test2            ; dann weiter
; externe Unterprogramme einfgen
        .INCLUDE "konsole.h"     ; enthlt Upros 
        .INCLUDE "aushex8.asm"   ; R16 hexa ausgeben
        .INCLUDE "puts.asm"      ; 
; aus16: Adresse Y und 16 Bytes ausgeben
aus16:  push    r16              ; Register retten
        push    r17              ;
        push    YL               ;
        push    YH               ;
        ldi     r16,10           ; neue Zeile
        rcall   putch            ;
        ldi     r16,13           ;
        rcall   putch            ;
        mov     r16,YH           ; Y ausgeben
        rcall   aushex8          ; lz $ Byte
        mov     r16,YL           ;
        rcall   aushex8a         ; nur Byte
        ldi     r17,16           ; 16 Bytes auf einer Zeile
aus16a: ld      r16,Y+           ; Adresse + 1
        rcall   aushex8          ; lz $ Byte ausgeben
        dec     r17              ;
        brne    aus16a           ;
        pop     YH               ; Register zurck
        pop     YL               ;
        pop     r17              ; 
        pop     r16              ; 
        ret                      ;
; konstante Texte
gut:    .DB     10,13,"SRAM getestet!",0,0     ;
err:    .DB     10,13,"SRAM-Fehler bei:",0,0   ;
        .EXIT                   ; Ende des Quelltextes 
