

; k7p2.asm Test Tiny2313  Potentialwechsel-Interrupt
; Port B: PB7 - PB0 Eingabe fr Potentialwechsel
; Port D: PD6 - PD0 Ausgabe fr Dualzhler bei jedem Interrupt
; Konfiguration: externer Quarz 3-8 MHz  externes Reset-Signal frei
        .INCLUDE    "tn2313def.inc" ; Deklarationen fr Tiny2313
        .DEF        akku = r16      ; Arbeitsregister
        .CSEG                       ; Programm-Flash
        rjmp        start           ; Reset-Einsprung
        .ORG        PCINTaddr       ; Einsprung Pin Change Interrupt
        rjmp        aufwachen       ;
        .ORG        $13             ; 
start:  ldi         akku,LOW(RAMEND) ; Stapel anlegen
        out         SPL,akku        ; kein SPH !
        ldi         akku,$ff        ; 
        out         DDRD,akku       ; Port D ist Ausgang
; Sleep-Betrieb Mode 0 0 idle vorbereiten
        in          akku,MCUCR      ; 
        cbr         akku,(1 << SM0) | (1 << SM1) ; 0   0
        sbr         akku,(1 << SE)               ;   1
        out         MCUCR,akku      ; Sleep-Mode frei
; Pin Change Interrupt vorbereiten
        ldi         akku,$ff        ; 1111 1111
        out         PCMSK,akku      ; Pin Change PB7 - PB0 frei
        in          akku,GIMSK      ; Externe Interrupt Freigabe
        sbr         akku,(1 << PCIE) ; PCIE frei
        out         GIMSK,akku      ;
        sei                         ; globale Interruptfreigabe 
loop:   sleep                       ; erweckt durch Potentialwechsel
        rjmp        loop            ; Schleife
;
;Interrupt-Einsprung durch Potentialwechsel
aufwachen:
        push        r16             ; R16 nach Stapel
        in          r16,SREG        ; Statusregister
        push        r16             ; nach Stapel
        in          r16,PORTD       ; alter Zhler
        inc         r16             ; +1
        out         PORTD,r16       ; neuer Zhler
        pop         r16             ; Statusregister
        out         SREG,r16        ; vom Stapel
        pop         r16             ; R16 vom Stapel
        reti                        ; Rckkehr aus Service
        .EXIT
