

; k6p1.asm ATmega8 Duo-LED und Bandanzeige
; Port B: 8bit Bandanzeige 
; Port C: PC0=ADC0 10 kOhm Poti PC1:LED grn PC2: LED rot
; Port D: 8bit analoger Messwert
; Konfiguration: interner Oszillator; externes Reset-Signal
        .INCLUDE "m8def.inc"     ; Deklarationen
        .DEF     akku = r16      ; Arbeitsregister
        .CSEG                    ; Programmsegment
         rjmp   start            ;
        .ORG    $13              ; keine Interrupts
start:  ldi     akku,LOW(RAMEND) ; Stapel anlegen
        out     SPL,akku         ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku         ;
        ldi     akku,$ff         ;
        out     DDRB,akku        ; Port B ist Ausgang
        out     DDRD,akku        ; Port D ist Ausgang
        ldi     akku,0b00000110  ; PC2 aus PC1 aus PC0=ADC0 ein
        out     DDRC,akku        ; Port D ist Ausgang
        ldi     akku,(0 << REFS1) | (0 << REFS0) | (0 << ADLAR) | 0;
        out     ADMUX,akku       ; Referenz, rechtsbndig, Kanal 0
        ldi     akku,(1 << ADEN) | (1 << ADSC) | (1 << ADPS1) | (1 << ADPS0);
        out     ADCSRA,akku      ; Wandler ein und starten, Einzel, Teiler 8
loop:   sbic    ADCSRA,ADSC      ; berspringe wenn Wandlung beendet
        rjmp    loop             ; warte auf Ende der Wandlung
        in      r17,ADCL         ; R17 = Low-Byte
        in      r18,ADCH         ; R18 = High-Byte
        lsr     r18              ; High 1 bit rechts
        ror     r17              ; Low  1 bit rechts
        lsr     r18              ; High 1 bit rechts
        ror     r17              ; Low  1 bit rechts
        out     PORTD,r17        ; 8bit Dualzahl ausgeben
; R17 = 8bit Dualzahl auf die drei Bereiche untersuchen
        cpi     r17,204          ; obere Grenze ca. 4 Volt
        brsh    gruen            ; grer: im grnen Bereich
        cpi     r17,51           ; untere Grenze ca. 1 Volt
        brlo    rot              ; kleiner: im roten Bereich
gelb:   sbi     PORTC,PC1        ; grn an
        sbi     PORTC,PC2        ; rot  an
        rjmp    next             ; weiter
gruen:  sbi     PORTC,PC1        ; grn an
        cbi     PORTC,PC2        ; rot  aus
        rjmp    next             ; weiter
rot:    cbi     PORTC,PC1        ; grn aus
        sbi     PORTC,PC2        ; rot  an
; R17 = 8bit Dualzahl nach Bandanzeige umwandeln
next:   ldi     r18,8            ; R18 = Zhler fr 8 Schritte
        ldi     r19,0b11111111   ; R19 = Bandausgabe 
        ldi     r20,224          ; R20 = Vergleichswert
next1:  cp      r17,r20          ; Dualzahl - Vergleichswert
        brsh    fertig           ; Dual >=: Vergleichswert 
        lsr     r19              ; Bandausgabe verkleinern
        subi    r20,32           ; Vergleichswert schrittweise vermindern
        dec     r18              ; Durchlaufzhler vermindern
        brne    next1            ; neuer Vergleich
fertig: out     PORTB,r19        ; Band auf Port B ausgeben
        sbi     ADCSRA,ADSC      ; Wandler neu starten
        rjmp    loop             ; Schleife
        .EXIT                    ; Ende des Quelltextes
