

; k4p8.asm  ATmega8  Timer1 Compare-Betrieb Rechteckgenerator
; Port B: Ausgang PB1 OC1A Signalausgabe 1 kHz Rechteck 1:1
; Port C: -
; Port D: -
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern
        .EQU    freq = 1000     ; 1000 Hz Rechteckausgabe
        .EQU    lade = takt/(2*freq) ; Ladewert fr Compare
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        sbi     DDRB,PB1        ; PB1 ist Ausgang OC1A
        ldi     akku,$C2        ; kalibrieren
        out     OSCCAL,akku     ; RC Oszillator
; Timer1: programmieren 
        ldi     akku,HIGH(lade) ; Compare A Register laden
        out     OCR1AH,akku     ;
        ldi     akku,LOW(lade)  ;
        out     OCR1AL,akku     ; 
        ldi     akku,(1 << COM1A0) ; OC1A umschalten
        out     TCCR1A,akku     ; Steuerregister A Timer1
        ldi     akku,0b001      ; Taktteiler :1
        ori     akku,(1 << WGM12) ; Timer1 nach match lschen
        out     TCCR1B,akku     ; Steuerregister B Timer1 start
; Arbeitsschleife 
loop:   nop                     ; tut nix mehr
        rjmp loop               ;
       .EXIT                    ; Ende des Quelltextes


