

; k4p5.asm  ATmega8  Timer1 Rechteckgenerator 1 kHz mit Korrekturen
; Port B: Ausgabe PB4 umschalten als Frequenzausgabe
; Port C: -
; Port D: -
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt ca. 1 MHz intern 
        .EQU    kali = $C2      ; Kalibrierungsbyte fr Oszillator
        .EQU    lade = takt/2000 - 16 ; Ladewert - Korrektur
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    OVF1addr        ; Einsprung Timer1 berlauf
        rjmp    time1           ; nach Interrupt-Service
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,(1 << PB4) ; PB4 als Ausgang
        out     DDRB,akku       ; 
        mov     r17,akku        ; R17 <- EODER-Maske fr PB4
        ldi     akku,kali       ; Oszillator 
        out     OSCCAL,akku     ; kalibrieren
; Timer1 programmieren
        ldi     akku,0b001      ; Systemtakt :1  
        out     TCCR1B,akku     ; Steuerregister B Timer1
        ldi     akku,HIGH(-lade); Ladewert
        out     TCNT1H,akku     ;
        ldi     akku,LOW(-lade) ;
        out     TCNT1L,akku     ;
        in      akku,TIMSK      ; altes Interrupt-Freigaberegister
        ori     akku,(1 << TOIE1) ; Timer1 berlauf Interrupt frei
        out     TIMSK,akku      ; neues Interrupt-Freigaberegister
        sei                     ; Interrupts frei
; Arbeitsschleife
loop:   nop                     ; tu nix
        rjmp    loop            ;
; Timer1 berlauf Interrupt Service 16 Takte Korrektur
time1:  push    r16             ;  2 Takte Register retten
        in      r16,SREG        ;  1 Takt
        push    r16             ;  2 Takte 
        ldi     akku,HIGH(-lade);  1 Takt neuer Ladewert
        out     TCNT1H,akku     ;  1 Takt
        ldi     akku,LOW(-lade) ;  1 Takt
        out     TCNT1L,akku     ;  1 Takt 
        in      akku,PORTB      ; altes PB4
        eor     akku,r17        ; komplementieren
        out     PORTB,akku      ; neues PB4
        pop     r16             ; Register zurck
        out     SREG,r16        ;
        pop     r16             ;
        reti                    ;
       .EXIT                    ; Ende des Quelltextes


