

; k4p16hs.asm  ATmega8  USART Test Hardwarehandshake-Protokoll
; Port B: Kontrollausgabe fr empfangene Zeichen
; Port C: -
; Port D: PD0->RXD PD1->TXD PD2 = PD4 Low PD3 = PD4 High PD4 RTS->CTS
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .EQU    baud = 9600     ; Baudrate
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    INT0addr        ; Einsprung INT0 PD2
        rjmp    ein             ;
        .ORG    INT1addr        ; Einsprung INT1 PD3
        rjmp    aus             ; 
        .ORG    $13             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ; 
        ldi     akku,$ff        ;
        out     DDRB,akku       ; Port B ist Ausgang fr Zeichencode
        sbi     DDRD,PD4        ; PD4 ist Ausgang RTS -> CTS
        rcall   initusart2      ; USART initialisieren doppelte Baudrate
        in      akku,MCUCR      ; Haupt-Steuerregister
        ori     akku,0b00001010 ; INT1 und INT0 fallende Flanke
        out     MCUCR,akku      ;
        in      akku,GICR       ; Interrupt-Freigaberegister
        ori     akku,0b11000000 ; INT1 und INT0 frei
        out     GICR,akku       ;
        sei                     ; alle Interrupts frei
neu:    ldi     akku,'>'        ; Prompt >
        rcall   putch           ; ausgeben
loop:   rcall   getche          ; Zeichen mit Echo empfangen
        out     PORTB,akku      ; Kontrollausgabe auf Port B
        rjmp    loop            ; und neue Eingabe
; Konsolunterprogramme einfgen
       .INCLUDE "konsole.h"     ; initusart2,putch,getch,getche,kbhit
; Interrupteinsprnge fr RTS -> CTS Protokoll
ein:    cbi     PORTD,PD4       ; PD4 Low:  Sender frei
        reti                    ; 
aus:    sbi     PORTD,PD4       ; PD4 High: Sender gesperrt
        reti                    ; 
        .EXIT                   ; Ende des Quelltextes

