

; k4p14m.asm ATmega8  USART Test der Konsolmakrofunktionen
; Port B: - 
; Port C: -
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .INCLUDE "Mkonsole.h"   ; Makros Minituart,Mputch,Mputkon,Mgetch,Mgetche,Mkbhit
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; weitere Interrupteinsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ; 
        ldi     akku,HIGH(RAMEND) ; 
        out     SPH,akku        ;        
        Minituart 9600          ; USART initialisieren 9600 Baud bei TAKT
neu:    Mputkon   '>'           ; > ausgeben
loop:   Mgetch  akku            ; Zeichen ohne Echo empfangen
        cpi     akku,$1b        ; Steuerzeichen Escape ?
        breq    warte           ; nein: kein Echo
        Mputch  akku            ;   ja: Echo
        rjmp    loop            ; und neue Eingabe
; Ausgabeschleife mit * bis Abbruch mit beliebiger Taste
warte:   Mputkon '*'            ; Sterne ausgeben
         Mkbhit  akku           ; Empfnger testen
         tst     akku           ; Akku <- Null Zeichen da ?
         breq    warte          ; Null: kein Zeichen da
         rjmp    neu            ; ungleich Null: Abbruchzeichen nicht ausgeben
         .EXIT                  ; Ende des Quelltextes

