

; k2p8.asm ATmega8 Dezimalzhler Taste PD7 softwaremssig entprellt
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111        
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
        clr     r18             ; dualen Ausgabezhler lschen         *
loop:   mov     akku,r18        ; dualen Zhler                        *
        rcall   dual2bcd        ; nach dezimal in R17:R16 umwandeln    *
        out     PORTC,r17       ; Hunderter auf Port C ausgeben        *
        out     PORTB,r16       ; Zehner und Einer auf Port B ausgeben *
oben:   sbic    PIND,PIND7      ; berspringe wenn Taste gedrckt      *
        rjmp    oben            ; warte solange Taste High             *
        ldi     r16,2           ; Faktor 2                             *
        rcall   wartex10ms      ; 20ms entprellen                      *
        inc     r18             ; Zhler dual erhhen                  *
unten:  sbis    PIND,PIND7      ; berspringe wenn Taste gelst        *
        rjmp    unten           ; warte solange Taste gedrckt         *
        ldi     r16,2           ; Faktor 2                             *
        rcall   wartex10ms      ; 20ms entprellen                      *
        rjmp    loop            ; bei steigender Flanke neue Ausgabe   *
; externes Unterprogramm R16 dual nach R17:R16 dezimal                 *
        .INCLUDE "dual2bcd.asm" ; wird hier aus Ordner eingefgt       *
        .INCLUDE "wartex10ms.asm" ; wird aus Ordner eingefgt          *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


