

; k2p7.asm ATmega8  16bit Dualzhler mit einstellbarer Wartezeit
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111        
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
        clr     r24             ; dualen Ausgabezhler lschen         *
        clr     r25             ;                                      *
loop:   out     PORTC,r25       ; High-Teil auf Port C ausgeben        *
        out     PORTB,r24       ; Low-Teil  auf Port B ausgeben        *
        adiw    r24,1           ; 16bit Zhlung + 1                    *
        in      r16,PIND        ; Wartefaktor vom Port D eingeben      *
        rcall   wartex10ms      ; R16 * 10 ms max. 2.55 sek warten     *
        rjmp    loop            ; dann neue Ausgabe                    *
; externes Unterprogramm Wartefaktor * 10 ms in R16 bergeben          *
        .INCLUDE "wartex10ms.asm"; wird hier aus Ordner eingefgt      *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


