

; k2p2.asm ATmega8 Dualzhler als Taktteiler Systemtakt 1 MHz
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111        
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testschleife in einfhrendes Beispiel einbauen *****************
; Testschleife 5 Takte Low 5 Takte High PB0: Takt/10 gemessen 99.0 kHz *
loop:   in      akku,PORTB      ; 1 Takt:  Eingabe alter Zhler        *
        inc     akku            ; 1 Takt:  Zhler um 1 erhhen         *
        out     PORTB,akku      ; 1 Takt:  neuen Zhler ausgeben       *
        rjmp    loop            ; 2 Takte: Sprung zum Schleifenanfang  *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


