

; k2p17.asm ATmega8 Aufbau und Ausgabe einer verketteten Liste
; Port B: Ausgabe PB7 .. PB0 acht  Leuchtdioden 
; Port C: Ausgabe PC5 .. PC0 sechs Leuchtdioden 
; Port D: Eingabe PD7 .. PD0 acht  Kippschalter
; Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
        .INCLUDE  "m8def.inc"   ; Deklarationen fr Mega8
        .EQU    takt = 1000000  ; Systemtakt 1 MHz intern 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $13             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
;****** Testprogramm in einfhrendes Beispiel einbauen *****************
; Verkettete Liste Anfangswerte Zhler und Zeiger laden                *
loop:   ldi     XL,LOW(liste)   ; X <- laufender Zeiger                *
        ldi     XH,HIGH(liste)  ; auf Listenelemente                   *
        sts     kopfz,XL        ; Kopfzeiger_Low <- Anfangsadresse     * 
        sts     kopfz+1,XH      ; Kopfzeiger_High                      *
        ldi     akku,$FF        ; Anfangsmarke 1111 1111               * 
        out     PORTB,akku      ; ausgeben                             *
; Verkettete Liste Eingabeschleife bis Null = Ende                     *
loop1:  sbic    PIND,PIND7      ; berspringe bei Low                  *
        rjmp    loop1           ; warte auf fallende Flanke            *
        in      akku,PIND       ; akku <- Daten von PIND6 bis PIND0    *
        tst     akku            ; Ende der Eingabe Marke Null ?        *
        breq    fertig          ;   ja: Ausgabe aller Testdaten        *
        out     PORTB,akku      ; nein: Port B Kontrollausgabe         *
        st      X+,akku         ;     : Datensatz ablegen              *
        ser     akku            ;       Datensatz Endemarke $ff        *
        st      X+,akku         ;       ablegen                        *
        mov     YL,XL           ; YL  <- Adresse_Low                   *
        mov     YH,XH           ; YH  <- Adresse High                  *
        adiw    YL,2            ; Nachfolgeradresse um 2 weiter        *
        st      X+,YL           ;       Adresse_Low  Nachfolger        *
        st      X+,YH           ;       Adresse_High Nachfolger        *
loop2:  sbis    PIND,PIND7      ; berspringe bei High                 *
        rjmp    loop2           ; warte auf steigende Flanke           *
        rjmp    loop1           ; Eingabeschleife bis Daten Null       *
; Ende der Eingabe letzter Satz: Daten $ff Adresse $0000               *
fertig: ser     akku            ; Datenende: $ff                       *
        st      X+,akku         ;                                      *
        clr     akku            ; Adresse Nachfolger $0000             *
        st      X+,akku         ;                                      *
        st      X+,akku         ;                                      *
; Verkettete Liste Ausgabe der Daten im Takt von 500 ms                *
        lds     YL,kopfz        ; Y <- Kopfzeiger                      *
        lds     YH,kopfz+1      ;                                      *
loop3:  ldi     akku,100        ; Faktor 100 * 10 ms = 1000 ms         *
        rcall   wartex10ms      ; 1 sek warten                         *
        ld      akku,Y+         ; Daten laden                          *
        cpi     akku,$ff        ; Endemarke ?                          *
        breq    weiter          ;   ja: nchster Satz                  *
        out     PORTB,akku      ; nein: Daten ausgeben                 *
        rjmp    loop3           ; neuen Satz lesen                     *
weiter: ld      akku,Y+         ; akku  <- Adresse_Low Nachfolger      *
        ld      r17,Y+          ; R17   <- Adresse_High Nachfolger     *
        mov     YL,akku         ; YL   <- Adresse_Low Nachfolger       *
        mov     YH,r17          ; YH   <- Adresse_High Nachfolger      *
        or      akku,r17        ; YL ODER YH: 16bit Adresse Null ?     *
        brne    loop3           ; nein: neuen Datensatz lesen          *
; Ende der verketteten Liste: neue Eingabe von Testwerten              *
        ldi     akku,100        ;   ja: Faktor 100 * 10 ms = 1 sek     *
        rcall   wartex10ms      ;       1000 ms warten                 *
        rjmp    loop            ;       neue Eingabe                   *
;                                                                      *
; Externes Unterprogramm hier einbauen                                 *
       .INCLUDE "wartex10ms.asm" ; wartet R16 * 10 ms bentigt TAKT    *
;                                                                      *
; Datenbereich im SRAM                                                 *
       .DSEG                    ; Datensegment ab $60                  *
kopfz: .BYTE    2               ; 16bit Kopfzeiger                     *
liste: .BYTE    1000            ; offene Liste max. 1000 Bytes         *
;***********************************************************************
        .EXIT                   ; Ende des Quelltextes


