


; bcd4dual.asm  R17:R16 dual <- R18=Zehnt. R17:R16=Taus | Hund | Zehn | Ein
bcd4dual:  push    r19      ; Register retten
           push    r20      ;
           push    r21      ;
           push    r22      ;
           push    r23      ; 
           push    r24      ;
; Stellen trennen mit BCD-Zifferprfung
           andi    r18,$0f  ; R18 <- 0 0 0 0 | Zehntausend
           cpi     r18,10  ; Ziffer 0 - 9 ?
           brsh    bcd4dualx ; >= 10: keine BCD-Ziffer
           mov     r19,r17  ; R19 <- Tausend | Hundert
           swap    r19      ; R19 <- Hundert | Tausend
           andi    r19,$0f  ; R19 <- 0 0 0 0 | Tausend
           cpi     r19,10  ; Ziffer 0 - 9 ?
           brsh    bcd4dualx ; >= 10: keine BCD-Ziffer
           mov     r20,r17  ; R20 <- Tausend | Hundert
           andi    r20,$0f  ; R20 <- 0 0 0 0 | Hundert
           cpi     r20,10  ; Ziffer 0 - 9 ?
           brsh    bcd4dualx ; >= 10: keine BCD-Ziffer
           mov     r21,r16  ; R21 <- Zehner  | Einer
           swap    r21      ; R21 <- Einer   | Zehner
           andi    r21,$0f  ; R21 <- 0 0 0 0 | Zehner
           cpi     r21,10  ; Ziffer 0 - 9 ?
           brsh    bcd4dualx ; >= 10: keine BCD-Ziffer
           mov     r22,r16  ; R22 <- Zehner  | Einer
           andi    r22,$0f  ; R22 <- 0 0 0 0 | Einer
           cpi     r22,10  ; Ziffer 0 - 9 ?
           brsh    bcd4dualx ; >= 10: keine BCD-Ziffer
; fortlaufende Multiplikationen
           clr     r17      ; R17 <- 0 0 0 0
           mov     r16,r18  ; R16 <- Zehntausend
           rcall   bcd4dual1; Z * 10
           add     r16,r19  ; Z * 10 + T
           rcall   bcd4dual1; (Z * 10 + T) * 10
           add     r16,r20  ; (Z * 10 + T) * 10 + H 
           clr     r20      ;
           adc     r17,r20  ; + Carry
           rcall   bcd4dual1; ((Z * 10 + T) * 10 + H) * 10 
           add     r16,r21  ; ((Z * 10 + T) * 10 + H) * 10 + Z
           clr     r21      ;
           adc     r17,r21  ; + Carry
           brcs    bcd4dual0; berlauf
           rcall   bcd4dual1; (((Z * 10 + T) * 10 + H) * 10 + Z) * 10
           brcs    bcd4dual0; berlauf
           add     r16,r22  ; (((Z * 10 + T) * 10 + H) * 10 + Z) * 10 + E
           clr     r22      ;
           adc     r17,r22  ; + Carry
           rjmp    bcd4dual0; Carry 0 oder 1 wird zurckgegeben
bcd4dualx: sec              ; Fehlermarke Carry = 1
bcd4dual0: pop     r24      ; Register  zurck
           pop     r23      ;
           pop     r22      ;
           pop     r21      ;
           pop     r20      ;
           pop     r19      ;
           ret              ; R17:R16 <- dual Carry = 1: berlauf
; R17:R16 <- R17:R16 * 10
bcd4dual1 :mov     r24,r17  ; R24 <- Retter High
           mov     r23,r16  ; R23 <- Retter Low
           lsl     r16      ; * 2
           rol     r17      ;
           brcs    bcd4dual2; berlauf
           lsl     r16      ; * 4
           rol     r17      ;
           brcs    bcd4dual2; berlauf
           add     r16,r23  ; * 5
           adc     r17,r24  ; 
           brcs    bcd4dual2; berlauf
           lsl     r16      ; * 10
           rol     r17      ;
           brcs    bcd4dual2; berlauf
bcd4dual2: ret              ;
