// k4p5.c ATmega8 Timer1 Rechteckgenerator 1 kHz mit Korrekturen
// Port B: Ausgabe PB4 umschalten als Frequenzausgabe
// Port C: -
// Port D:
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h> // Deklarationen
//     #include <avr/signal.h> // fr Interrupt
#include <avr/interrupt.h> // fr Interrupt
#define TAKT 1000000UL // Controllertakt 1 MHz
#define kali 0xC2 // Kalibrierungsbyte fr Oszillator
#define lade -(TAKT/2000ul - 22ul) // Ladewert - Korrektur
ISR (TIMER0_OVF_vect)// Servicefunktion Timer1 berlauf
{
	TCNT1 = lade; // Timer1 Ladewert fr 2 kHz mit Korrektur
	PORTB ^= (1 << PB4); // PB4 komplementieren
}
void main(void) // Hauptfunktion
{
	DDRB = (1 << PB4); // PB4 ist Ausgang
	OSCCAL = kali; // internen RC Oszillator kalibrieren
	TCNT1 = lade; // Timer1 Ladewert fr 2 kHz mit Korrektur
	TCCR1B |= 0x01; // Timer1 Teiler 1
	TIMSK |= (1 << TOIE1); // Timer1 berlauf Interrupt frei
	sei(); // alle Interrupts frei
	while(1) // Arbeitsschleife tut nix
	{ } // Ende while
} // Ende main