

// k7p8.asm ATmega16 4stellige LCD-Anzeige
// Port A: A7 = Eingang Std+   A6-A0 = Ausgang Stelle links
// Port B: B7 = Ausgang COL    B6-B0 = Ausgang Stelle mitte links
// Port C: C7 = Ausgang BP     C6-C0 = Ausgang Stelle mitter rechts
// Port D: D7 = Eingang Min+   D6-D0 = Ausgang Stelle rechts
// Konfiguration Quarz 3.6864 MHz  JTAG Interface disabled!
#define     TAKT 3686400ul     // Systemtakt 3.6864 MHz
#include    <avr/io.h>         // Deklarationen
#include    <avr/signal.h>     // Deklarationen fr Interrupt
#include    <avr/interrupt.h>  // Deklarationen fr Interrupt
#include    "wartex10ms.c"     // wartet faktor*10ms Symbol TAKT
#include    "dual3bcd.c"       // dual nach BCD dreistellig 
volatile unsigned char s1=0,s2=0,s3=0,s4=0,zael=225,sekunde=0,minute=0,stunde=0; // global
unsigned char hun, zeh, ein ;          // Hilfsvariablen fr dual3bcd
const unsigned char ctab[] = \
{ 0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0x77,0x7C,0x39,0x5E,0x79,0x71}; // 0-F 
void anzeig (void)                     // Zeit umrechnen und ausgeben
{
   dual3bcd(minute, &hun, &zeh, &ein); // Minute BCD dreistellig
   s1 = ctab[ein]; if (zeh == 0) s2 = 0; else s2 = ctab[zeh];
   dual3bcd(stunde, &hun, &zeh, &ein); // Stunde BCD dreistellig
   s3 = ctab[ein]; if (zeh == 0) s4 = 0; else s4 = ctab[zeh];
}
SIGNAL (SIG_OVERFLOW0)                 // Service Timer0 berlauf 
{
 s1 = ~s1; s2 = ~s2; s3 = ~s3; s4 = ~s4;         // Muster komplementieren
 PORTA = s4; PORTB = s3; PORTC = s2; PORTD = s1; // Muster nach Ausgabeport
 zael--; if (zael == 0)                // Interruptzhler Null ?
 {
  zael = 225; s3 = s3 ^ 0x80;          // Doppelpunkt blinkt 
  sekunde++; if (sekunde == 60)        // Sekundenzhler voll ?
  {
   sekunde = 0;
   minute++; if (minute == 60)         // Minutenzhler voll ?
   {
    minute = 0;
    stunde++; if (stunde == 24) stunde = 0; // Stundenzhler
   } // Ende if-minute
   anzeig();                           // Zeit codieren und anzeigen
  } // Ende if-sekunde
 } // Ende if-zael
} // Ende Service

void main (void)                       // Hauptfunktion
{
 DDRA = DDRD = 0x7f;                   // B7 Eingang  B6-B0 Ausgnge
 DDRB = DDRC = 0xff;                   // B7-B0 Ausgnge
 TCCR0 |= (1 << CS01) | (1 << CS00);   // 3686400 : Teiler 64 : 256 = 225 Hz
 TIMSK |=  (1 << TOIE0);               // Timer0 Interrupt frei
 sei();                                // I = 1 Interrupts global frei
 anzeig();                             // Startwerte codieren und anzeigen
 while (1)                             // Arbeitsschleife kontrolliert Taster PD7 und PA7
 {
  while ( (PIND & (1 << PD7)) && (PINA & (1 << PA7)) ); // solange beide Taster High
  if ( !(PIND & (1 << PD7)))           // fallende Flanke PD7
  {
   minute++; if (minute == 60) minute = 0;
   anzeig(); wartex10ms(2);             // anzeigen und entprellen 20 ms
   while( !(PIND & (1 << PD7)));       // warte auf steigende Flanke
   wartex10ms(2);                      // entprellen 20 ms
  } // ENde if-PD7
  if ( !(PINA & (1 << PA7)))           // fallende Flanke PA7
  {
   stunde++; if (stunde == 24) stunde = 0;
   anzeig(); wartex10ms(2);            // anzeigen und entprellen 20 ms
   while( !(PINA & (1 << PA7)));       // warte auf steigende Flanke
   wartex10ms(2);                      // entprellen 20 ms
  } // Ende if-PA7
 } // Ende while
} //Ende main
