

// k6p2.c  ATtiny2313  9stellige Multiplexanzeige 
// Port B: PB7 - PB0 Ausgabe aller Segment-Katoden
// Port D: PD3 - PD0 Ausgabe Auswahl Anoden  PD6: Eingang Taster
// Konfiguration: externer Quarz 3-8 MHz  externes Reset-Signal frei
// externer Quarz 3.072 MHz : 256 = 12000 = Zhler 12 fr 1 kHz 1 ms
#include <avr/io.h>            // Deklarationen einfgen
#include <avr/interrupt.h>     // Interrupt-Funktionen
#include <avr/signal.h>        // Interrupt-Funktionen
unsigned char aus[9],durch,zael;// globale Variablen
unsigned char ctab[10] = {0x3f,0x06,0x5b,0x4f,0x66,0x6d,0x7d,0x07,0x7f,0x6f};
void loesch (void)             // alle Stellen lschen
{
 unsigned char i;
 for (i=0; i< 9; i++) aus[i] = 0; // alle Stellen Null
}
void zaehler(void)             // neunstelligen Dezimalzhler erhhen
{
 unsigned char i;
 for (i = 0; i < 9; i++)       // fr alle Stellen 
 {
  aus[8-i]++;                  // Stelle erhhen
  if (aus[8-i] < 10) break;    // kein bertrag
  else aus[8-i] = 0;           // bertrag: Stelle 0 und weiter
 }
}
SIGNAL(SIG_TIMER0_OVF)         // Timer0 berlauf
{

  if (zael-- == 0)             // 12 Durchlufe = 1 ms erreicht
  {                            // neue Stelle ausgeben
   zael = 12;                  // neuer Anfangswert
   PORTB = ctab[aus[durch-1]]; // Segmente umcodieren und ausgeben
   PORTD = durch-1;            // Anode ansteuern
   zaehler();                  // Ausgabezhler erhhen
   durch--;
   if(durch == 0) durch = 9; // Ausgabe wieder von vorn beginnen
  }
} 
void main(void)                // Hauptfunktion
{ 
 DDRB = 0xff;                  // Port B ist Ausgang
 DDRD = 0x0f;                  // 0000 1111 PD6 Eingang PD3-PD0 Ausgang
 loesch();                     // alle Stellen lschen (mit 0 besetzt)
 zael = 12;                    // Anfangswert Interrupt-Durchlaufzhler
 durch = 9;                    // Anfangswert Stellenindex und Zhler
 TCCR0B = (1 << CS00);         // fr TCCR0 Taktteiler Faktor /1
 TIMSK = (1 << TOIE0);         // Timer0 Interrupt frei
 sei();                        // globale Interruptfreigabe
 while(1)                 
 {                         
  while( PIND & (1 << PD6));   // warte solange High
  cli(); loesch(); sei();      // fallende Flanke: Ausgabezhler lschen
  while (!(PIND & (1 << PD6)));// warte solange Low
 }                          
}                          
