

// k4p26xp.c  ATmega8  USART Test des Xon/Xoff-Handshakeverfahrens
// Port B: Kontrollausgabe fr empfangene Zeichen 
// Port D: PD0 -> RXD  PD1 -> TXD  PD2 = XON  PD3 = XOFF 
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal 
#include <avr/io.h>        // Deklarationen
#include <avr/signal.h>    // Deklarationen fr Interrupt
#include <avr/interrupt.h> // Deklarationen fr Interrupt
#define TAKT 1000000UL     // Controllertakt 1 MHz
#define BAUD 9600UL        // Baudrate 
#define SLAENG 80          // fr Funktion getstring in konsole.h
#include "konsole.h"       // Funktionen initusart2,putch,getch,getche,kbhit
// ISR (INT0_vect)         // neue Bezeichnung fr Interruptservice
SIGNAL(SIG_INTERRUPT0)     // alte Bezeichnung fr Interruptservice
{
 putch(0x11);              // Taste PD2 = INT0 sendet XON
}
// ISR (INT1_vect)         // neue Bezeichnung fr Interruptservice
SIGNAL(SIG_INTERRUPT1)     // alte Bezeichnung fr Interruptservice
{
 putch(0x13);              // Taste PD3 = INT1 sendet XOFF
}
main(void)                 // Hauptfunktion
{
 DDRB = 0xff;              // Port B zur Kontrollusgabe
 initusart2();             // USART initialisieren doppelte Baudrate
 MCUCR |= (1 << ISC11) | (1 << ISC10);  //  INT1 und INT0 fallende Flanke
 GIMSK |= (1 << INT1)  | (1 << INT0);   //  INT1 und INT0 frei
 sei();                    // alle Interrupts frei
 putch('>');               // Prompt ausgeben
 while(1)                  // Arbeitsschleife
 {
  PORTB = getche();        // Zeichen lesen mit Echo und Kontrollausgabe
 } // Ende while
} // Ende main

