

// k3p22.c  ATmega8  Externer Interrupt INT0 (PD2)
// Port B: Ausgabe Zhler
// Port D: Eingabe Taste PD6: Zhler lschen  Taste PD2 (INT0): Zhler + 1
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include <avr/io.h>         // Deklarationen
#include <avr/signal.h>     // Deklarationen fr Interrupt
#include <avr/interrupt.h>  // Deklarationen fr Interrupt
#define TAKT 1000000UL      // Controllertakt 1 MHz
// ISR (INT0_vect)          // neue Bezeichnung fr Interruptservice
SIGNAL(SIG_INTERRUPT0)      // alte Bezeichnung fr Interruptservice 
{
 PORTB++;                  // Zhler um 1 erhhen
}
void main(void)           // Hauptfunktion
{
 DDRB = 0xff;              // Port B ist Ausgang
 MCUCR |= (1 << ISC01);    // INT0 fallende Flanke
 GIMSK |= (1 << INT0);     // INT0 frei
 sei();                    // alle Interrupts frei
 while(1)                  // Arbeitsschleife fr Taste PIND6
 {
  while(PIND & (1 <<  PD6));      // warte auf fallende Flanke
  PORTB = 0;                       // Zhler lschen
  while( ! (PIND & (1 << PD6))); // warte auf steigende Flanke
 } // Ende while
} // Ende main
