

// k3p21.c ATmega8  benutzerdefinierte Ein-/Ausgabe-Funktionen 
// Port D: PD1 = TXD und PD0 = RXD -> PC als Terminal
// Konfiguration: interner Oszillator 1 MHz, externes RESET-Signal
#include   <avr/io.h>     // Deklarationen
#define    TAKT 1000000ul // Controllertakt 1 MHz
#define    BAUD 9600ul    // 9600 Baud 
#define    SLAENG 81      // Lnge Eingabestring
// Konsolfunktionen einfgen: initusart2 putch getch getche kbhit putstring getstring cmpstring
#include   "konsole.h"     // USART Konsolfunktionen Zeichen und Strings
// Globaler Pufferspeicher und laufende Pufferposition
unsigned char puffer[SLAENG], ppos; 
// interne Eingabefunktion aus globalem Pufferspeicher
unsigned char einz(void)  
{
  return puffer[ppos++];   // Zeichen aus Puffer Zeiger + 1 
} 
// interne direkte Ausgabefunktion
void ausz(unsigned char zeichen)  // direkte Ausgabe nach Gert
{
 putch(zeichen);                   // nach USART 
}
// einfgen: ausbin8 aushex8 ausudez16 ausidez16 einudez16 einidez16 einhex16
#include "einaus.h"                 // Umwandlung und Ein/Ausgabe
// Hauptfunktion
void main (void)                  // Hauptfunktion
{
 unsigned char zeichen, marke;   // Zeichen und Fehlermarke
 unsigned int uwort;             // unsigned Zahl 16bit 
 int iwort;                       // signed Zahl 16bit 
 initusart2();                     // USART initialisieren
 while(1)                         // Arbeitsschleife 
 {
  // ASCII-Zeichen lesen und Cde binr, hexadezimal und dezimal ausgeben
  putstring("\n\n\r         ein Zeichen -> ");
  getstring(puffer); ppos = 0;    // Eingabe nach Pufferspeicher
  zeichen = einz();               // Zeichen aus Puffer
  ausbin8(zeichen);               // binre Ausgabe
  aushex8(zeichen);               // hexadezimale Ausgabe
  ausudez16(zeichen);             // unsigned dezimale Ausgabe
  ausidez16((int)zeichen);       // signed dezimale Ausgabe
  //
  // vorzeichenlose Dezimalzahl lesen und ausgeben
  putstring("\n\rZahl ohne Vorzeichen -> ");
  getstring(puffer); ppos = 0;   // Eingabe nach Pufferspeicher
  marke = einudez16(&uwort);     // nach unsigned int umwandeln
  if(marke) ausudez16(uwort);    // unsigned dezimale Ausgabe
  if (!marke) putstring("  Fehler");
  // 
  // vorzeichenbehaftete Dezimalzahl lesen und ausgeben
  putstring("\n\r Zahl mit Vorzeichen -> ");
  getstring(puffer); ppos = 0;   // Eingabe nach Pufferspeicher
  marke = einidez16(&iwort);     // nach unsigned int umwandeln
  if(marke) ausidez16(iwort);    // signed dezimale Ausgabe
  if (!marke) putstring("  Fehler"); 
  //
  // Hexadezimalzahl lesen und ausgeben
  putstring("\n\r      0x hexadezimal -> ");
  getstring(puffer); ppos = 0;   // Eingabe nach Pufferspeicher
  marke = einhex16(&uwort);      // hexa nach unsigned int umwandeln
  if(marke) ausudez16(uwort);    // unsigned dezimale Ausgabe
  if (!marke) putstring("  Fehler"); 
 } // Ende while-Schleife
} // Ende main