
; warte20ms.asm
; Unterprogramm wartet 20 ms bei TAKT von 1 bis 16 MHz
; Symbol TAKT im Hauptprogramm in [Hz] vereinbart
warte20ms:
        push    XL              ; Register retten
        push    XH              ;
        .IF     (TAKT/250)>65535   ; Anfangswert fr max. 16 MHz
         .ERROR "Fehler: TAKT > 16 MHz"
        .ELSE
        ldi     XL,LOW(TAKT/250)  ; 8 MHz / 250 = 32 000 
        ldi     XH,HIGH(TAKT/250) ; (32 000 * 5)/8 [us] = 20 ms
        .ENDIF
warte20ms1:
        nop                     ; 1 Takt 
        sbiw    XL,1            ; 2 Takte
        brne    warte20ms1      ; 2 Takte
        pop     XH              ; Register zurck
        pop     XL              ;
        ret                     ; Rcksprung 