

; test3.asm ATMega16 32bit Dualzhler 400 kHz an PD0
; PORTA: Ausgabe High-Byte        B31-B24
; PORTB: Ausgabe Middle-High-Byte B23-B16
; PORTC: Ausgabe Middle-Low-Byte  B15-B8
; PORTD: Ausgabe Low-Byte         B7-B0
        .INCLUDE  "m16def.inc"  ; Deklarationen fr Mega16
        .EQU    takt = 8000000  ; Systemtakt 8 MHz 
        .DEF    akku = r16      ; Arbeitsregister
        .CSEG                   ; Programm-Flash
        rjmp    start           ; Reset-Einsprung
        .ORG    $2A             ; Interrupt-Einsprnge bergehen
start:  ldi     akku,LOW(RAMEND); Stapel anlegen
        out     SPL,akku        ;
        ldi     akku,HIGH(RAMEND) ;
        out     SPH,akku        ;
        ldi     akku,$ff        ; Bitmuster 1111 1111
        out     DDRA,akku       ; Port A ist Ausgane
        out     DDRB,akku       ; Port B ist Ausgang
        out     DDRC,akku       ; Port C ist Ausgang
        out     DDRD,akku       ; Port D ist Ausgang
        clr     XL              ; Low-Zhler lschen
        clr     XH              ;
        clr     YL              ; High-Zhler lschen
        clr     YH              ;
; 32bit Zhler 10 Takte Low / 10 Takte High PD0 Systemtakt / 20
loop:   out     PORTD,XL        ; 1 Takt:  Low-Zhler ausgeben
        out     PORTC,XH        ; 1 Takt
        out     PORTB,YL        ; 1 Takt:  High-Zhler ausgeben 
        out     PORTA,YH        ; 1 Takt:  
        adiw    XL,1            ; 2 Takte: Low-Zhler + 1
        brcc    next            ; 2 Takte: bei Sprung 1 Takt bei Nichtsprung
        adiw    YL,1            ; 2 Takte: High-Zhler + 1
next:   rjmp    loop            ; 2 Takte: Schleife
        .EXIT                   ; Ende des Quelltextes

