


; test16.asm Test der signed Multiplikation und Division
; Port B: - 
; Port D: PD0 -> RXD  PD1 -> TXD  COM1 9600 Bd 
        .INCLUDE "m16def.inc"    ; Deklarationen fr ATmega16
        .INCLUDE "Mkonsole.h"    ; Makros mit Konsolfunktionen
        .INCLUDE "Mmuldiv.h"     ; Makros Multiplikation und Division
        .EQU    TAKT = 8000000   ; Systemtakt 8 MHz
        .EQU    NPUF = 80        ; Lnge des Eingabepuffers
        .DEF    akkul = r16      ; Arbeitsregister Low
        .DEF    akkuh = r17      ; Arbeitsregister High
        .CSEG                    ; Programm-Flash
         rjmp   start            ; Reset-Einsprung
        .ORG    $2A              ; Interrupteinsprnge bergehen
start:   ldi    akkul,LOW(RAMEND) ; Stapelzeiger laden
         out    SPL,akkul        ;
         ldi    akkul,HIGH(RAMEND);
         out    SPH,akkul        ;
         Minituart 9600          ; USART 9600 Baud bei Frequenz TAKT
         ldi    ZL,LOW(prompt*2) ; Z <- Adresse Ausgabetext
         ldi    ZH,HIGH(prompt*2);
; Arbeitsschleife 
loop:    rcall  puts             ; Prompt: Eingabe -> 
         ldi    YL,LOW(puffer)   ; Y <- Adresse Eingabepuffer
         ldi    YH,HIGH(puffer)  ;
         rcall  gets             ; Eingabezeile nach Puffer Ende mit cr
         rcall  eindez16s        ; R17:R16 <- Eingabewert
         brcs   error            ; C = 1: Eingabefehler
         movw   r19:r18,r17:r16  ; R19:R18 <- Faktor
         rcall  puts             ; Prompt: Eingabe -> 
         ldi    YL,LOW(puffer)   ; Y <- Adresse Eingabepuffer
         ldi    YH,HIGH(puffer)  ;
         rcall  gets             ; Eingabezeile nach Puffer Ende mit cr
         rcall  eindez16s        ; R17:R16 <- Eingabewert
         brcs   error            ; C = 1: Eingabefehler
; Test der Multiplikation
         rcall  muls16           ; R3:R2:R1:R0 <- R17:R16 * R19:R18 mul-Befehl
         rcall  ausdez32s        ; 32bit Kontroll-Ausgabe
         rcall  mulsx16          ; Software signed
         rcall  ausdez32s        ; 32bit Kontroll-Ausgabe
; Test der Division
         movw   r3:r2,r19:r18    ; Dividend
         movw   r1:r0,r17:r16    ; Divisor
         rcall  divsx16          ; R3:R2 <- Quotient  R1:R0 <- Rest
         movw   r17:r16,r3:r2    ; Quotient
         rcall  ausdez16s        ;
         movw   r17:r16,r1:r0    ; Rest
         rcall  ausdez16s        ;
         rjmp   loop             ; 
; Fehlermeldung
error:   Mputkon '?'               ;
         Mputkon 7               ;
         rjmp   loop             ;
; interne Unterprogramme fr Gert und Betriebsart
ausz:    Mputch r16              ; direkte Ausgabe nach USART
         ret                     ; 
einz:    ld     r16,Y+           ; gepufferte Eingabe von USART aus (Y)
         ret                     ; 
; externe Unterprogramme String und Umwandlung
         .INCLUDE "gets.asm"     ; Zeile von USART nach SRAM Adresse in Y
         .INCLUDE "puts.asm"     ; Text aus Flash ausgeben
         .INCLUDE "einaus.h"     ; Ein/Ausgabe-Unterprogramme 
         .INCLUDE "muldiv.h"     ; Multiplikation und Division
;
; Ausgabetext
prompt:  .DB     10,13,"Eingabe -> ",0
; SRAM-Bereich 
         .DSEG                   ; Datenbereich
puffer:  .BYTE   NPUF            ; Eingabepuffer fr gets
         .EXIT                   ; Ende des Quelltextes

