

; tastatur.asm enthlt Upros taste und eintas
; Interne Tastaturunterprogramme bentigen Unterprogramm warte1ms
; Zeileneingnge: PC3 PC2 PC1 PC0 PB0
; Spaltenausgnge: PD3 PD4 PD5 PD6 PD7
; taste: R16 <- Tastencode nach Drcken   R16 <- Null: keine Taste 
taste:  push     r0              ; Register retten
        push     r17             ;
        push     r18             ;
        push     r19             ; Spaltenzhler
        push     r20             ; Zeilenzhler
        push     ZH              ;
        push     ZL              ;
        ldi      ZL,LOW(tastab*2); Z <- Anfangsadresse Codetabelle
        ldi      ZH,HIGH(tastab*2);
        ldi      r16,0b00001111  ; Zeileneingnge PC3 PC2 PC1 PC0
        out      PORTC,r16       ; auf High legen
        sbi      PORTB,PB0       ; Zeileneingang PB0 auf High legen
; Spaltenschleife 
        ldi      r19,5           ; R19 = Spaltenzhler Anfangswert
        ldi      r16,0b01111000  ; R16 = Ausgangsmuster fr Spalten
taste1: mov      r17,r16         ; R17 = Ausgabemuster fr Spalten
        andi     r17,0b11111000  ; Maske PD2 PD1 PD0 lschen
        out      PORTD,r17       ; Spalte auf Low
        nop                      ; Pause der Ergriffenheit
        nop                      ;
        in       r18,PINC        ; R18 = Zeilen PC3 - PC0 rcklesen
        andi     r18,0b00001111  ; Bit_7 - Bit_4 lschen
        lsl      r18             ; B1 <- B0   B4 <- B3
        sbic     PINB,PB0        ; berspringe wenn PB0 = Low
        ori      r18,0b00000001  ; PB0 = High: Bit_0 = 1
; Zeilenschleife
        ldi      r20,5           ; R20 = Zeilenzhler Anfangswert
taste2: lsr      r18             ; Testbit -> Carry
        brcc     taste3          ; Bit = 0: Taste gedrckt
        adiw     ZL,1            ; Bit = 1: Codeadresse + 1
        dec      r20             ; Zeilenzhler - 1
        brne     taste2          ; bis alle Zeilen durch
        asr      r16             ; Spaltencode nach rechts 
        ori      r16,0b10000000  ; Bit_7 <- 1
        dec      r19             ; Spaltenzhler - 1
        brne     taste1          ; bis alle Spalten durch
; keine Taste erkannt
        ldi      r16,20          ; 20 ms warten
taste2a:rcall    warte1ms        ; zum Entprellen
        dec      r16             ;
        brne     taste2a         ;
        clr      r16             ; R16 = Null: keine Taste
        rjmp     taste4          ; 
; Taste erkannt Code nach R16
taste3: ldi      r16,20          ; 20 ms warten 
taste3a:rcall    warte1ms        ; zum Entprellen
        dec      r16             ;
        brne     taste3a         ; 
        lpm                      ; R0 <- Code aus Tabelle (Z)
        mov      r16,r0          ; R16 = Rckgabecode
taste4: pop      ZL              ; Register zurck
        pop      ZH              ;
        pop      r20             ;
        pop      r19             ;
        pop      r18             ;
        pop      r17             ;
        pop      r0              ; 
        ret                      ; R16 = Rckgabe
tastab: .DB  "048C",9,"159D",8,"26AE",7,"37BF",6,1,2,3,4,5,10,0,0 ; Tastencodetabelle
;
; eintas R16 <- Tastencode nach Lsen der Taste
eintas: push     r17             ; Register retten
eintas1:rcall    taste           ; R16 <- Taste
        tst      r16             ; Null ?
        breq     eintas1         ; keine Taste
        mov      r17,r16         ; R17 rettet Code
eintas2:rcall    taste           ; R16 <- Taste
        tst      r16             ; 
        brne     eintas2         ; warte bis gelst
        mov      r16,r17         ; R16 <- Tastencode
        clr      r17             ; alle Spalten
        out      PORTD,r17       ; auf Low
        pop      r17             ; Register zurck
        ret                      ;
